/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.di;

import java.io.FileNotFoundException;
import java.util.List;
import ru.autosome.commons.backgroundModel.di.DiBackground;
import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.backgroundModel.di.DiWordwiseBackground;
import ru.autosome.commons.importer.DiPWMFromMonoImporter;
import ru.autosome.commons.importer.DiPWMImporter;
import ru.autosome.commons.importer.MotifImporter;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.motifModel.di.DiPWM;
import ru.autosome.commons.scoringModel.DiPWMSequenceScoring;
import ru.autosome.perfectosape.model.SequenceWithSNV;
import ru.autosome.perfectosape.model.encoded.di.SequenceDiEncoded;
import ru.autosome.perfectosape.model.encoded.di.SequenceWithSNVDiEncoded;

public class SNPScan
extends ru.autosome.perfectosape.cli.generalized.SNPScan<SequenceDiEncoded, SequenceWithSNVDiEncoded, DiPWM, DiPWMSequenceScoring, DiBackgroundModel> {
    boolean fromMononucleotide;

    @Override
    protected String DOC_run_string() {
        return "java ru.autosome.perfectosape.di.SNPScan";
    }

    @Override
    protected String DOC_background_option() {
        return "ACGT - 16 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.02,0.03,0.03,0.02,0.08,0.12,0.12,0.08,0.08,0.12,0.12,0.08,0.02,0.03,0.03,0.02";
    }

    @Override
    protected String DOC_additional_options() {
        return "  [--from-mono] - obtain collection DiPWMs from mono PWM/PCM/PPMs.\n";
    }

    @Override
    protected void initialize_defaults() {
        super.initialize_defaults();
        this.fromMononucleotide = false;
    }

    @Override
    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        if (opt.equals("--from-mono")) {
            this.fromMononucleotide = true;
            return false;
        }
        return true;
    }

    @Override
    protected void extract_background(String str) {
        this.background = DiBackground.fromString(str);
    }

    @Override
    protected void initialize_default_background() {
        this.background = new DiWordwiseBackground();
    }

    @Override
    protected List<Named<DiPWM>> load_collection_of_pwms() {
        MotifImporter importer = this.fromMononucleotide ? new DiPWMFromMonoImporter((DiBackgroundModel)this.background, this.dataModel, (Double)this.effectiveCount, this.transpose, this.pseudocount) : new DiPWMImporter((DiBackgroundModel)this.background, this.dataModel, this.effectiveCount, this.transpose, this.pseudocount);
        return importer.loadMotifCollectionWithNames(this.path_to_collection_of_pwms);
    }

    @Override
    protected SequenceWithSNVDiEncoded encodeSequenceWithSNV(SequenceWithSNV sequenceWithSNV) {
        return SequenceWithSNVDiEncoded.encode(sequenceWithSNV);
    }

    protected static ru.autosome.perfectosape.cli.generalized.SNPScan from_arglist(String[] args) throws FileNotFoundException {
        SNPScan result = new SNPScan();
        result.setup_from_arglist(args);
        return result;
    }

    public static void main(String[] args) {
        try {
            ru.autosome.perfectosape.cli.generalized.SNPScan calculation = SNPScan.from_arglist(args);
            calculation.process();
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\n" + new SNPScan().documentString());
            System.exit(1);
        }
    }
}

