/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.model.encoded.mono;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.perfectosape.model.Sequence;
import ru.autosome.perfectosape.model.SequenceWithSNV;
import ru.autosome.perfectosape.model.encoded.EncodedSequenceWithSNVType;
import ru.autosome.perfectosape.model.encoded.mono.SequenceMonoEncoded;

public class SequenceWithSNVMonoEncoded
implements EncodedSequenceWithSNVType<SequenceMonoEncoded> {
    private final List<SequenceMonoEncoded> sequenceVariants;
    private final int length;

    public SequenceWithSNVMonoEncoded(List<SequenceMonoEncoded> sequenceVariants) {
        if (sequenceVariants.size() < 2) {
            throw new IllegalArgumentException("There should be at least two sequences in SequenceWithSNVMonoEncoded");
        }
        this.length = sequenceVariants.get(0).length();
        for (int i = 1; i < sequenceVariants.size(); ++i) {
            if (sequenceVariants.get(i).length() == this.length) continue;
            throw new IllegalArgumentException("All sequences should be of equal length");
        }
        this.sequenceVariants = sequenceVariants;
    }

    @Override
    public SequenceMonoEncoded sequenceVariant(int alleleNumber) {
        return this.sequenceVariants.get(alleleNumber);
    }

    @Override
    public int length() {
        return this.length;
    }

    public static SequenceWithSNVMonoEncoded encode(SequenceWithSNV sequenceWithSNV) {
        ArrayList<SequenceMonoEncoded> encodedVariants = new ArrayList<SequenceMonoEncoded>(sequenceWithSNV.num_cases());
        for (Sequence seq : sequenceWithSNV.sequence_variants()) {
            encodedVariants.add(SequenceMonoEncoded.encode(seq));
        }
        return new SequenceWithSNVMonoEncoded(encodedVariants);
    }
}

