/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.findThreshold;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.ape.calculation.findThreshold.FindThresholdExact;
import ru.autosome.ape.calculation.findThreshold.FoundedThresholdInfo;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreDistribution;

public class FindThresholdAPE<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType>
implements CanFindThreshold {
    final FindThresholdExact<ModelType, BackgroundType> thresholdCalculator;
    final Discretizer discretizer;

    public FindThresholdAPE(ModelType motif, BackgroundType background, Discretizer discretizer) {
        this.discretizer = discretizer;
        this.thresholdCalculator = new FindThresholdExact<ScoreDistribution, BackgroundType>((ScoreDistribution)motif.discrete(discretizer), background);
    }

    @Override
    public FoundedThresholdInfo thresholdByPvalue(double pvalue, BoundaryType boundaryType) {
        return this.thresholdCalculator.thresholdByPvalue(pvalue, boundaryType).downscale(this.discretizer);
    }

    @Override
    public List<FoundedThresholdInfo> thresholdsByPvalues(List<Double> pvalues, BoundaryType boundaryType) {
        List<FoundedThresholdInfo> infos_upscaled = this.thresholdCalculator.thresholdsByPvalues(pvalues, boundaryType);
        ArrayList<FoundedThresholdInfo> result = new ArrayList<FoundedThresholdInfo>();
        for (FoundedThresholdInfo info_upscaled : infos_upscaled) {
            result.add(info_upscaled.downscale(this.discretizer));
        }
        return result;
    }
}

