/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.cli;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.commons.cli.ParameterDescription;
import ru.autosome.commons.cli.ReportLayout;
import ru.autosome.commons.cli.Reporter;
import ru.autosome.commons.cli.ValueWithDescription;
import ru.autosome.commons.support.StringExtensions;

public class TextReporter<ResultInfo>
implements Reporter<ResultInfo> {
    @Override
    public String report(ResultInfo data, ReportLayout<ResultInfo> layout) {
        ArrayList<String> sections = new ArrayList<String>();
        sections.add(this.formatParameter(layout.parameters));
        sections.add(this.formatResult(data, layout.resulting_values));
        ArrayList<String> results = new ArrayList<String>();
        for (String section : sections) {
            if (section.isEmpty()) continue;
            results.add(section);
        }
        return StringExtensions.join(results, "\n#\n");
    }

    protected String parameter_description_string(String param_name, String description) {
        return "# " + param_name + ": " + description;
    }

    protected String formatParameter(List<ValueWithDescription> parameters) {
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (ValueWithDescription parameter : parameters) {
            if (parameter.description != null) {
                descriptions.add(this.parameter_description_string(parameter.name, parameter.description));
            }
            values.add("# " + parameter.name + " = " + parameter.value);
        }
        return StringExtensions.glueSections(StringExtensions.join(descriptions, "\n"), StringExtensions.join(values, "\n"));
    }

    protected String formatResult(ResultInfo data, List<ParameterDescription<ResultInfo>> parameters) {
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (ParameterDescription<ResultInfo> parameter : parameters) {
            if (parameter.description != null) {
                descriptions.add(this.parameter_description_string(parameter.name, parameter.description));
            }
            values.add(parameter.name + "\t" + parameter.callback.apply(data));
        }
        return StringExtensions.glueSections(StringExtensions.join(descriptions, "\n"), StringExtensions.join(values, "\n"));
    }
}

