/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.importer;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import ru.autosome.commons.importer.InputExtensions;
import ru.autosome.commons.importer.ParsingResult;
import ru.autosome.commons.model.Named;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class MotifImporter<ModelType> {
    public abstract ModelType createMotif(double[][] var1);

    public abstract ParsingResult parse(List<String> var1);

    public ModelType loadMotif(List<String> lines) {
        return this.loadMotifWithName(lines).getObject();
    }

    public ModelType loadMotif(File file) {
        return this.loadMotifWithName(file).getObject();
    }

    public Named<ModelType> loadMotifWithName(List<String> lines) {
        ParsingResult parsingInfo = this.parse(lines);
        return new Named<ModelType>(this.createMotif(parsingInfo.getMatrix()), parsingInfo.getName());
    }

    public ModelType loadMotif(String filename) {
        return this.loadMotifWithName(filename).getObject();
    }

    public Named<ModelType> loadMotifWithName(File file) {
        List<String> lines;
        try {
            lines = InputExtensions.readLinesFromFile(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        ParsingResult parsingInfo = this.parse(lines);
        String name = parsingInfo.getName() == null || parsingInfo.getName().isEmpty() ? file.getName().replaceAll("\\.[^.]+$", "") : parsingInfo.getName();
        return new Named<ModelType>(this.createMotif(parsingInfo.getMatrix()), name);
    }

    public Named<ModelType> loadMotifWithName(String filename) {
        return this.loadMotifWithName(new File(filename));
    }

    public List<ModelType> loadMotifCollection(File pathToMotifs) {
        List<Named<ModelType>> namedMotifs = this.loadMotifCollectionWithNames(pathToMotifs);
        ArrayList<ModelType> result = new ArrayList<ModelType>(namedMotifs.size());
        for (Named<ModelType> namedModel : namedMotifs) {
            result.add(namedModel.getObject());
        }
        return result;
    }

    public List<Named<ModelType>> loadMotifCollectionWithNames(File pathToMotifs) {
        if (pathToMotifs.isDirectory()) {
            return this.loadMotifCollectionWithNamesFromFolder(pathToMotifs);
        }
        return this.loadMotifCollectionWithNamesFromFile(pathToMotifs);
    }

    public List<Named<ModelType>> loadMotifCollectionWithNamesFromFolder(File pathToPWMs) {
        ArrayList<Named<ModelType>> result = new ArrayList<Named<ModelType>>();
        File[] files = pathToPWMs.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            Named<ModelType> motif = this.loadMotifWithName(file);
            if (motif == null) continue;
            result.add(motif);
        }
        return result;
    }

    public List<Named<ModelType>> loadMotifCollectionWithNamesFromFile(File pathToPWMs) {
        throw new NotImplementedException();
    }
}

