/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.motifModel.mono;

import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.converter.mono.PCM2PWM;
import ru.autosome.commons.converter.mono.PPM2PCM;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.mono.PCM;
import ru.autosome.commons.motifModel.mono.PM;
import ru.autosome.commons.motifModel.mono.PWM;
import ru.autosome.commons.motifModel.types.PositionFrequencyModel;

public class PPM
extends PM
implements PositionFrequencyModel {
    public PPM(double[][] matrix) throws IllegalArgumentException {
        super(matrix);
        for (double[] pos : matrix) {
            double sum = 0.0;
            for (int letter = 0; letter < 4; ++letter) {
                sum += pos[letter];
            }
            if (!(Math.abs(sum - 1.0) > 0.001)) continue;
            throw new IllegalArgumentException("sum of each column should be 1.0(+-0.001), but was " + sum);
        }
    }

    public PCM to_pcm(double count) {
        return (PCM)new PPM2PCM(count).convert(this);
    }

    public PWM to_pwm(BackgroundModel background, double count, PseudocountCalculator pseudocount) {
        PCM pcm = (PCM)new PPM2PCM(count).convert(this);
        return (PWM)new PCM2PWM(background, pseudocount).convert(pcm);
    }
}

