/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculation;

import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.model.PositionInterval;
import ru.autosome.commons.scoringModel.SequenceScoringModel;
import ru.autosome.perfectosape.model.PositionWithScore;
import ru.autosome.perfectosape.model.RegionAffinityInfos;
import ru.autosome.perfectosape.model.RegionAffinityVariantInfo;
import ru.autosome.perfectosape.model.Sequence;
import ru.autosome.perfectosape.model.SequenceWithSNV;
import ru.autosome.perfectosape.model.encoded.EncodedSequenceType;
import ru.autosome.perfectosape.model.encoded.EncodedSequenceWithSNVType;

public class SingleSNVScan<SequenceType extends EncodedSequenceType, SequenceWithSNVType extends EncodedSequenceWithSNVType<SequenceType>, ModelType extends SequenceScoringModel<SequenceType>> {
    private final ModelType pwm;
    private final SequenceWithSNV sequenceWithSNV;
    private final SequenceWithSNVType encodedSequenceWithSNP;
    private final CanFindPvalue pvalueCalculator;
    private final int expandRegionLength;

    public SingleSNVScan(ModelType pwm, SequenceWithSNV sequenceWithSNV, SequenceWithSNVType encodedSequenceWithSNP, CanFindPvalue pvalueCalculator, int expandRegionLength) {
        if (sequenceWithSNV.length() < pwm.length()) {
            throw new IllegalArgumentException("Can't scan sequence '" + sequenceWithSNV + "' (length " + sequenceWithSNV.length() + ") with motif of length " + pwm.length());
        }
        this.pwm = pwm;
        this.sequenceWithSNV = sequenceWithSNV;
        this.encodedSequenceWithSNP = encodedSequenceWithSNP;
        this.pvalueCalculator = pvalueCalculator;
        this.expandRegionLength = expandRegionLength;
        if (sequenceWithSNV.length() < pwm.length()) {
            throw new IllegalArgumentException("Can't estimate affinity to sequence '" + sequenceWithSNV + "' (length " + sequenceWithSNV.length() + ") for motif of length " + pwm.length());
        }
        if (sequenceWithSNV.num_cases() != 2) {
            throw new IllegalArgumentException("Unable to process more than two variants of nucleotide for SNP " + sequenceWithSNV);
        }
    }

    PositionInterval positionsToCheck() {
        return this.sequenceWithSNV.positionsOverlappingSNV(this.pwm.length()).expand(this.expandRegionLength);
    }

    public RegionAffinityVariantInfo affinityVariantInfo(int allele_number) {
        EncodedSequenceType encodedSequence = (EncodedSequenceType)this.encodedSequenceWithSNP.sequenceVariant(allele_number);
        PositionWithScore bestPositionWithScore = this.positionsToCheck().findBestPosition(encodedSequence, this.pwm);
        Position pos = bestPositionWithScore.getPosition();
        Position pos_centered = new Position(pos.position() - this.sequenceWithSNV.left.length(), pos.orientation());
        double score = bestPositionWithScore.getScore();
        double pvalue = this.pvalueCalculator.pvalueByThreshold((double)score).pvalue;
        Character allele = Character.valueOf(this.sequenceWithSNV.mid[allele_number]);
        Sequence sequence = this.sequenceWithSNV.sequence_variants()[allele_number];
        Sequence word = sequence.substring(pos, this.pwm.length());
        return new RegionAffinityVariantInfo(pos_centered, allele, pvalue, word);
    }

    public RegionAffinityInfos affinityInfos() {
        return new RegionAffinityInfos(this.affinityVariantInfo(0), this.affinityVariantInfo(1));
    }
}

