/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.calculation.findThreshold.FoundedThresholdInfo;
import ru.autosome.ape.model.PvalueBsearchList;
import ru.autosome.ape.model.ThresholdPvaluePair;
import ru.autosome.ape.model.progression.GeometricProgression;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreBoundaries;
import ru.autosome.commons.motifModel.ScoreDistribution;

public class PrecalculateThresholdList<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType> {
    public static final List<Double> PVALUE_LIST = new GeometricProgression(1.0, 1.0E-15, 1.05).values();
    final List<Double> pvalues;
    final BoundaryType pvalue_boundary;
    final Discretizer discretizer;
    final BackgroundType background;

    public PrecalculateThresholdList(List<Double> pvalues, Discretizer discretizer, BackgroundType background, BoundaryType pvalue_boundary) {
        this.pvalues = pvalues;
        this.discretizer = discretizer;
        this.background = background;
        this.pvalue_boundary = pvalue_boundary;
    }

    protected CanFindThreshold find_threshold_calculator(ModelType motif) {
        return new FindThresholdAPE<ModelType, BackgroundType>(motif, this.background, this.discretizer);
    }

    public PvalueBsearchList bsearch_list_for_pwm(ModelType motif) {
        List<FoundedThresholdInfo> infos = this.find_threshold_calculator(motif).thresholdsByPvalues(this.pvalues, this.pvalue_boundary);
        ArrayList<ThresholdPvaluePair> pairs = new ArrayList<ThresholdPvaluePair>(infos.size() + 2);
        for (FoundedThresholdInfo info : infos) {
            pairs.add(new ThresholdPvaluePair(info));
        }
        double worstScore = ((ScoreBoundaries)motif).worst_score();
        double bestScore = ((ScoreBoundaries)motif).best_score();
        double eps = 1.0;
        if (bestScore - worstScore > 0.0 && bestScore - worstScore < eps) {
            eps = bestScore - worstScore;
        }
        pairs.add(new ThresholdPvaluePair(worstScore, 1.0));
        pairs.add(new ThresholdPvaluePair(bestScore + (eps *= 0.1), 0.0));
        return new PvalueBsearchList(pairs);
    }
}

