/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.cli.generalized;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.autosome.ape.calculation.PrecalculateThresholdList;
import ru.autosome.ape.model.PvalueBsearchList;
import ru.autosome.ape.model.progression.Progression;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.Helper;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreDistribution;
import ru.autosome.commons.motifModel.types.DataModel;

public abstract class PrecalculateThresholds<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected Discretizer discretizer;
    protected BackgroundType background;
    protected BoundaryType pvalue_boundary;
    protected DataModel data_model;
    protected double effective_count;
    protected PseudocountCalculator pseudocount;
    protected boolean silenceLog;
    protected File results_dir;
    protected Named<ModelType> single_motif;
    protected List<Double> pvalues;
    protected boolean transpose;
    protected List<Named<ModelType>> motifList;

    protected abstract void initialize_default_background();

    protected abstract void extract_background(String var1);

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected abstract Named<ModelType> loadMotif(File var1);

    protected PrecalculateThresholdList<ModelType, BackgroundType> calculator() {
        return new PrecalculateThresholdList(this.pvalues, this.discretizer, this.background, this.pvalue_boundary);
    }

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.discretizer = new Discretizer(1000.0);
        this.pvalue_boundary = BoundaryType.STRONG;
        this.pvalues = PrecalculateThresholdList.PVALUE_LIST;
        this.data_model = DataModel.PWM;
        this.effective_count = 100.0;
        this.pseudocount = PseudocountCalculator.logPseudocount;
        this.silenceLog = false;
        this.transpose = false;
    }

    protected void setup_from_arglist(String[] args) throws IOException {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        this.setup_from_arglist(argv);
    }

    protected void setup_from_arglist(List<String> argv) throws IOException {
        Helper.print_help_if_requested(argv, this.documentString());
        if (argv.remove("--single-motif")) {
            String motif_filename = argv.remove(0);
            File single_motif_file = new File(motif_filename);
            if (!argv.isEmpty() && !argv.get(0).startsWith("-")) {
                this.extract_output_folder_name(argv);
                this.create_results_folder();
            }
            while (argv.size() > 0) {
                this.extract_option(argv);
            }
            this.single_motif = this.loadMotif(single_motif_file);
        } else {
            File[] collection_folder = this.extract_collection_files(argv);
            this.extract_output_folder_name(argv);
            this.create_results_folder();
            while (argv.size() > 0) {
                this.extract_option(argv);
            }
            this.motifList = this.loadMotifs(collection_folder);
        }
    }

    protected File[] extract_collection_files(List<String> argv) {
        try {
            File collection_folder = new File(argv.remove(0));
            File[] files = collection_folder.listFiles();
            if (files == null) {
                System.err.println("Warning! No files in collection folder `" + collection_folder + "`!");
                return new File[0];
            }
            return files;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify PWM-collection folder", e);
        }
    }

    protected void extract_output_folder_name(List<String> argv) {
        try {
            this.results_dir = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify output folder", e);
        }
    }

    protected void create_results_folder() throws IOException {
        this.results_dir.mkdirs();
        if (!this.results_dir.exists()) {
            throw new IOException("Can't create output folder " + this.results_dir.getAbsolutePath());
        }
    }

    protected void extract_option(List<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b") || opt.equals("--background")) {
            this.extract_background(argv.remove(0));
        } else if (opt.equals("--pvalues")) {
            this.pvalues = Progression.fromString(argv.remove(0)).values();
        } else if (opt.equals("-d") || opt.equals("--discretization")) {
            this.discretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalue_boundary = BoundaryType.fromString(argv.remove(0));
        } else if (opt.equals("--pcm")) {
            this.data_model = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.data_model = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            this.effective_count = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pseudocount")) {
            this.pseudocount = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--silent")) {
            this.silenceLog = true;
        } else if (opt.equals("--transpose")) {
            this.transpose = true;
        } else if (this.failed_to_recognize_additional_options(opt, argv)) {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        return true;
    }

    List<Named<ModelType>> loadMotifs(File[] files) {
        ArrayList<Named<ModelType>> results = new ArrayList<Named<ModelType>>();
        for (File file : files) {
            results.add(this.loadMotif(file));
        }
        return results;
    }

    protected void calculate_thresholds() throws IOException {
        if (this.single_motif != null) {
            PvalueBsearchList bsearchList = this.calculator().bsearch_list_for_pwm((Discretable)this.single_motif.getObject());
            if (this.results_dir != null) {
                File result_filename = new File(this.results_dir, this.single_motif.getName() + ".thr");
                bsearchList.save_to_file(result_filename);
            } else {
                bsearchList.print_to_stream(new OutputStreamWriter(System.out));
            }
        } else {
            for (Named<ModelType> motif : this.motifList) {
                if (!this.silenceLog) {
                    System.err.println(motif.getName());
                }
                PvalueBsearchList bsearchList = this.calculator().bsearch_list_for_pwm((Discretable)motif.getObject());
                File result_filename = new File(this.results_dir, motif.getName() + ".thr");
                bsearchList.save_to_file(result_filename);
            }
        }
    }

    public String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <collection folder> <output folder> [options]\n  or\n" + this.DOC_run_string() + " <motif file> <output_folder> --single-motif [options]\n" + this.DOC_run_string() + " <motif file> --single-motif [options]\n  (the latter variant outputs threshold - P-value list to stdin)\n\nOptions:\n  [--single-motif] - calculate thresholds for a single motif, not a motif collection\n  [--discretization <discretization level>] or [-d]\n  [--pcm] - treat the input files as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [--boundary lower|upper] Lower boundary (default) means that the obtained P-value is less than or equal to the requested P-value\n  [--background <background probabilities>] or [-b] " + this.DOC_background_option() + "\n  [--pvalues <min pvalue>,<max pvalue>,<step>,<mul|add>] pvalue list parameters: boundaries, step, arithmetic(add)/geometric(mul) progression\n  [--silent] - suppress logging\n  [--transpose] - load motif from transposed matrix (nucleotides in lines).\n" + this.DOC_additional_options() + "\nExamples:\n  " + this.DOC_run_string() + " ./hocomoco/ ./hocomoco_thresholds/\n  " + this.DOC_run_string() + " ./hocomoco/ ./hocomoco_thresholds/ -d 100 --pvalues 1e-6,0.1,1.5,mul\n";
    }

    protected String DOC_additional_options() {
        return "";
    }

    protected PrecalculateThresholds() {
        this.initialize_defaults();
    }
}

