/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.model.progression;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.model.progression.Progression;

public class GeometricProgression
extends Progression {
    final double from;
    final double to;
    final double step;

    @Override
    public List<Double> values() {
        ArrayList<Double> results = new ArrayList<Double>();
        if (this.to >= this.from) {
            for (double x = this.from; x <= this.to; x *= this.step) {
                results.add(x);
            }
        } else {
            for (double x = this.from; x >= this.to; x *= this.step) {
                results.add(x);
            }
        }
        return results;
    }

    public GeometricProgression(double from, double to, double step) {
        this.from = from;
        this.to = to;
        if (step <= 0.0) {
            throw new IllegalArgumentException("Step should be positive");
        }
        this.step = to >= from ? (step > 1.0 ? step : 1.0 / step) : (step < 1.0 ? step : 1.0 / step);
    }
}

