/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.test;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import ru.autosome.ape.model.PvalueBsearchList;
import ru.autosome.ape.model.ThresholdPvaluePair;
import ru.autosome.commons.model.BoundaryType;

public class PvalueBsearchListTest {
    @Test
    public void testPvalueByThreshold() {
        ArrayList<ThresholdPvaluePair> pairs = new ArrayList<ThresholdPvaluePair>();
        for (double threshold = 0.0; threshold < 10.0; threshold += 1.0) {
            pairs.add(new ThresholdPvaluePair(threshold, (10.0 - threshold) / 10.0));
        }
        PvalueBsearchList bsearchList = new PvalueBsearchList(pairs);
        Assert.assertEquals((Object)new ThresholdPvaluePair(5.0, 0.5), (Object)bsearchList.thresholdInfoByPvalue(0.55, BoundaryType.STRONG));
        Assert.assertEquals((Object)new ThresholdPvaluePair(4.0, 0.6), (Object)bsearchList.thresholdInfoByPvalue(0.55, BoundaryType.WEAK));
        Assert.assertEquals((Object)new ThresholdPvaluePair(4.0, 0.6), (Object)bsearchList.thresholdInfoByPvalue(0.6, BoundaryType.STRONG));
        Assert.assertEquals((Object)new ThresholdPvaluePair(4.0, 0.6), (Object)bsearchList.thresholdInfoByPvalue(0.6, BoundaryType.WEAK));
        Assert.assertEquals((double)0.4, (double)bsearchList.pvalue_by_threshold(6.0), (double)1.0E-7);
        Assert.assertEquals((double)Math.sqrt(0.2), (double)bsearchList.pvalue_by_threshold(5.3), (double)1.0E-7);
        Assert.assertEquals((double)Math.sqrt(0.2), (double)bsearchList.pvalue_by_threshold(5.5), (double)1.0E-7);
        Assert.assertEquals((double)Math.sqrt(0.2), (double)bsearchList.pvalue_by_threshold(5.8), (double)1.0E-7);
    }
}

