/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.converter.generalized;

import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.converter.generalized.MotifConverter;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.types.PositionCountModel;
import ru.autosome.commons.motifModel.types.PositionWeightModel;

public abstract class PCM2PWM<ModelTypeFrom extends PositionCountModel, ModelTypeTo extends PositionWeightModel, BackgroundType extends GeneralizedBackgroundModel>
implements MotifConverter<ModelTypeFrom, ModelTypeTo> {
    public final PseudocountCalculator pseudocountCalculator;
    public final GeneralizedBackgroundModel background;

    protected abstract BackgroundType defaultBackground();

    protected abstract ModelTypeTo createMotif(double[][] var1);

    public PCM2PWM(BackgroundType background, PseudocountCalculator pseudocountCalculator) {
        this.background = background;
        this.pseudocountCalculator = pseudocountCalculator;
    }

    public PCM2PWM() {
        this.background = this.defaultBackground();
        this.pseudocountCalculator = PseudocountCalculator.logPseudocount;
    }

    @Override
    public Named<ModelTypeTo> convert(Named<ModelTypeFrom> namedModel) {
        return new Named<ModelTypeTo>(this.convert((ModelTypeFrom)((PositionCountModel)namedModel.getObject())), namedModel.getName());
    }

    @Override
    public ModelTypeTo convert(ModelTypeFrom pcm) {
        double[][] new_matrix = new double[pcm.getMatrix().length][];
        for (int pos = 0; pos < pcm.getMatrix().length; ++pos) {
            new_matrix[pos] = this.convert_position(pcm.getMatrix()[pos]);
        }
        return this.createMotif(new_matrix);
    }

    private double count(double[] pos) {
        double count = 0.0;
        for (double element : pos) {
            count += element;
        }
        return count;
    }

    private double[] convert_position(double[] pos) {
        double count = this.count(pos);
        double pseudocount = this.pseudocountCalculator.calculatePseudocount(count);
        double[] converted_pos = new double[pos.length];
        for (int letter = 0; letter < pos.length; ++letter) {
            double numerator = pos[letter] + this.background.probability(letter) * pseudocount;
            double denominator = this.background.probability(letter) * (count + pseudocount);
            converted_pos[letter] = Math.log(numerator / denominator);
        }
        return converted_pos;
    }
}

