/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.importer;

import java.util.List;
import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.importer.ChIPMunkParser;
import ru.autosome.commons.importer.MotifImporter;
import ru.autosome.commons.importer.NormalMatrixParser;
import ru.autosome.commons.importer.ParsingResult;
import ru.autosome.commons.importer.TransposedMatrixParser;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.mono.PCM;
import ru.autosome.commons.motifModel.mono.PPM;
import ru.autosome.commons.motifModel.mono.PWM;
import ru.autosome.commons.motifModel.types.DataModel;
import ru.autosome.commons.support.StringExtensions;

public class PWMImporter
extends MotifImporter<PWM> {
    final DataModel dataModel;
    final Double effectiveCount;
    final PseudocountCalculator pseudocountCalculator;
    final BackgroundModel background;
    final boolean transpose;

    public PWMImporter() {
        this.dataModel = DataModel.PWM;
        this.effectiveCount = null;
        this.pseudocountCalculator = PseudocountCalculator.logPseudocount;
        this.background = null;
        this.transpose = false;
    }

    public PWMImporter(BackgroundModel background, DataModel dataModel, Double effectiveCount, boolean transpose, PseudocountCalculator pseudocount) {
        this.dataModel = dataModel;
        this.effectiveCount = effectiveCount;
        this.pseudocountCalculator = pseudocount;
        this.background = background;
        this.transpose = transpose;
    }

    @Override
    public PWM createMotif(double[][] matrix) {
        PWM pwm;
        switch (this.dataModel) {
            case PCM: {
                pwm = new PCM(matrix).to_pwm(this.background, this.pseudocountCalculator);
                break;
            }
            case PPM: {
                pwm = new PPM(matrix).to_pwm(this.background, this.effectiveCount, this.pseudocountCalculator);
                break;
            }
            case PWM: {
                pwm = new PWM(matrix);
                break;
            }
            default: {
                throw new Error("This code never reached");
            }
        }
        return pwm;
    }

    @Override
    public ParsingResult parse(List<String> strings) {
        if (StringExtensions.startWith(strings.get(0), "PROG|ru.autosome.ChIPMunk")) {
            return new ChIPMunkParser(4, "ru.autosome.ChIPMunk", "PWMA").parse(strings);
        }
        if (this.transpose) {
            return new TransposedMatrixParser(4).parse(strings);
        }
        return new NormalMatrixParser(4).parse(strings);
    }
}

