/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.motifModel.di;

import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.MatrixModel;

public class DiPM
implements MatrixModel,
HasLength {
    public static final int ALPHABET_SIZE = 16;
    protected final double[][] matrix;

    public DiPM(double[][] matrix) throws IllegalArgumentException {
        for (double[] pos : matrix) {
            if (pos.length == 16) continue;
            throw new IllegalArgumentException("Matrix must have 16 elements in each position");
        }
        this.matrix = matrix;
    }

    @Override
    public int length() {
        return this.matrix.length + 1;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (double[] pos : this.matrix) {
            for (int letter_index = 0; letter_index < this.alphabetSize(); ++letter_index) {
                if (letter_index != 0) {
                    result.append("\t");
                }
                result.append(pos[letter_index]);
            }
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public double[][] getMatrix() {
        return this.matrix;
    }

    @Override
    public int alphabetSize() {
        return 16;
    }

    double[][] discretizedMatrix(Discretizer discretizer) {
        double[][] result = new double[this.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            result[i] = new double[16];
            for (int j = 0; j < 16; ++j) {
                result[i][j] = discretizer.discrete(this.matrix[i][j]);
            }
        }
        return result;
    }
}

