/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.motifModel.di;

import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.converter.di.PCM2PWM;
import ru.autosome.commons.converter.di.PPM2PCM;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.di.DiPCM;
import ru.autosome.commons.motifModel.di.DiPM;
import ru.autosome.commons.motifModel.di.DiPWM;
import ru.autosome.commons.motifModel.types.PositionFrequencyModel;

public class DiPPM
extends DiPM
implements PositionFrequencyModel {
    public DiPPM(double[][] matrix) throws IllegalArgumentException {
        super(matrix);
        for (double[] pos : matrix) {
            double sum = 0.0;
            for (int letter = 0; letter < 4; ++letter) {
                sum += pos[letter];
            }
            if (!(Math.abs(sum - 1.0) > 0.001)) continue;
            throw new IllegalArgumentException("sum of each column should be 1.0(+-0.001), but was " + sum);
        }
    }

    public DiPCM to_pcm(double count) {
        return (DiPCM)new PPM2PCM(count).convert(this);
    }

    public DiPWM to_pwm(DiBackgroundModel background, double count, PseudocountCalculator pseudocount) {
        DiPCM pcm = (DiPCM)new PPM2PCM(count).convert(this);
        return (DiPWM)new PCM2PWM(background, pseudocount).convert(pcm);
    }
}

