/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.calculation.generalized;

import java.util.Comparator;
import java.util.function.Function;
import ru.autosome.ape.calculation.findPvalue.FoundedPvalueInfo;
import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.macroape.calculation.generalized.AlignedModelIntersection;
import ru.autosome.macroape.model.AlignmentGenerator;
import ru.autosome.macroape.model.ComparisonSimilarityInfo;
import ru.autosome.macroape.model.PairAligned;

public class CompareModelsExact<ModelType extends Alignable<ModelType>> {
    private final AlignmentGenerator<ModelType> alignmentGenerator;
    private final int backgroundVolume;
    private final Function<PairAligned<ModelType>, ? extends AlignedModelIntersection> calculatorOfAligned;

    public CompareModelsExact(ModelType firstPWM, ModelType secondPWM, int backgroundVolume, Function<PairAligned<ModelType>, ? extends AlignedModelIntersection> calculatorOfAligned) {
        this.backgroundVolume = backgroundVolume;
        this.calculatorOfAligned = calculatorOfAligned;
        this.alignmentGenerator = new AlignmentGenerator<ModelType>(firstPWM, secondPWM);
    }

    public ComparisonSimilarityInfo jaccard(FoundedPvalueInfo first, FoundedPvalueInfo second) {
        return this.alignmentGenerator.relative_positions().map(position -> this.jaccardAtPosition(first, second, (Position)position)).max(Comparator.comparingDouble(ComparisonSimilarityInfo::similarity)).get();
    }

    public ComparisonSimilarityInfo jaccardFixedStrand(FoundedPvalueInfo first, FoundedPvalueInfo second, Orientation strand) {
        return this.alignmentGenerator.relative_positions_fixed_strand(strand).map(position -> this.jaccardAtPosition(first, second, (Position)position)).max(Comparator.comparingDouble(ComparisonSimilarityInfo::similarity)).get();
    }

    public ComparisonSimilarityInfo jaccardAtPosition(FoundedPvalueInfo first, FoundedPvalueInfo second, Position position) {
        PairAligned<ModelType> alignment = this.alignmentGenerator.alignment(position);
        double intersection = this.calculatorOfAligned.apply(alignment).count_in_intersection(first.threshold, second.threshold);
        double vocabularySize = Math.pow(this.backgroundVolume, alignment.length());
        return new ComparisonSimilarityInfo(alignment, intersection, first.pvalue * vocabularySize, second.pvalue * vocabularySize);
    }
}

