/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.calculation.generalized;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import ru.autosome.ape.calculation.findPvalue.FindPvalueAPE;
import ru.autosome.ape.calculation.findPvalue.FoundedPvalueInfo;
import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.calculation.findThreshold.FoundedThresholdInfo;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.macroape.calculation.generalized.AlignedModelIntersection;
import ru.autosome.macroape.calculation.generalized.CompareModels;
import ru.autosome.macroape.model.ComparisonSimilarityInfo;
import ru.autosome.macroape.model.PairAligned;
import ru.autosome.macroape.model.ScanningSimilarityInfo;
import ru.autosome.macroape.model.ThresholdEvaluator;

public class ScanningCollection<ModelType extends Alignable<ModelType> & Discretable<ModelType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected final List<ThresholdEvaluator<ModelType>> thresholdEvaluators;
    public final ModelType queryPWM;
    public double pvalue;
    public Double queryPredefinedThreshold;
    public Discretizer roughDiscretizer;
    public Discretizer preciseDiscretizer;
    public BackgroundType background;
    public BoundaryType pvalueBoundaryType;
    public Double similarityCutoff;
    public Double preciseRecalculationCutoff;
    public final Function<PairAligned<ModelType>, ? extends AlignedModelIntersection> calculatorOfAligned;

    public ScanningCollection(List<ThresholdEvaluator<ModelType>> thresholdEvaluators, ModelType queryPWM, Function<PairAligned<ModelType>, ? extends AlignedModelIntersection> calculatorOfAligned) {
        this.thresholdEvaluators = thresholdEvaluators;
        this.queryPWM = queryPWM;
        this.calculatorOfAligned = calculatorOfAligned;
    }

    public ComparisonSimilarityInfo comparisonInfo(FoundedPvalueInfo countByThresholdQuery, ModelType pwmKnown, CanFindThreshold thresholdCalculatorKnown, Discretizer discretizer) {
        CompareModels<ModelType> calc = new CompareModels<ModelType>(this.queryPWM, pwmKnown, this.background.volume(), discretizer, this.calculatorOfAligned);
        FoundedThresholdInfo knownInfo = thresholdCalculatorKnown.thresholdByPvalue(this.pvalue, this.pvalueBoundaryType);
        FoundedPvalueInfo countByThresholdKnown = knownInfo.toFoundedPvalueInfo();
        return calc.jaccard(countByThresholdQuery, countByThresholdKnown);
    }

    public ScanningSimilarityInfo similarityInfo(FoundedPvalueInfo roughCountByThresholdQuery, FoundedPvalueInfo preciseCountByThresholdQuery, ThresholdEvaluator<ModelType> knownMotifEvaluator) {
        boolean precise = false;
        ComparisonSimilarityInfo info = this.comparisonInfo(roughCountByThresholdQuery, (Alignable)knownMotifEvaluator.pwm, knownMotifEvaluator.rough, this.roughDiscretizer);
        if (this.preciseRecalculationCutoff != null && info.similarity() >= this.preciseRecalculationCutoff && knownMotifEvaluator.precise != null) {
            info = this.comparisonInfo(preciseCountByThresholdQuery, (Alignable)knownMotifEvaluator.pwm, knownMotifEvaluator.precise, this.preciseDiscretizer);
            precise = true;
        }
        if (this.similarityCutoff == null || info.similarity() >= this.similarityCutoff) {
            return new ScanningSimilarityInfo(knownMotifEvaluator.name, info, precise);
        }
        return null;
    }

    public Stream<ScanningSimilarityInfo> similarityInfos() {
        FindPvalueAPE<Discretable, BackgroundType> roughQueryPvalueEvaluator = new FindPvalueAPE<Discretable, BackgroundType>((Discretable)this.queryPWM, this.background, this.roughDiscretizer);
        FindPvalueAPE<Discretable, BackgroundType> preciseQueryPvalueEvaluator = new FindPvalueAPE<Discretable, BackgroundType>((Discretable)this.queryPWM, this.background, this.preciseDiscretizer);
        double roughQueryThreshold = this.queryThreshold(this.roughDiscretizer);
        double preciseQueryThreshold = this.queryThreshold(this.preciseDiscretizer);
        FoundedPvalueInfo roughCountByThresholdQuery = roughQueryPvalueEvaluator.pvalueByThreshold(roughQueryThreshold);
        FoundedPvalueInfo preciseCountByThresholdQuery = preciseQueryPvalueEvaluator.pvalueByThreshold(preciseQueryThreshold);
        return this.thresholdEvaluators.stream().map(knownMotifEvaluator -> this.similarityInfo(roughCountByThresholdQuery, preciseCountByThresholdQuery, (ThresholdEvaluator<ModelType>)knownMotifEvaluator)).filter(Objects::nonNull);
    }

    double queryThreshold(Discretizer discretizer) {
        if (this.queryPredefinedThreshold != null) {
            return this.queryPredefinedThreshold;
        }
        FindThresholdAPE<Discretable, BackgroundType> pvalue_calculator = new FindThresholdAPE<Discretable, BackgroundType>((Discretable)this.queryPWM, this.background, discretizer);
        return pvalue_calculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundaryType).threshold;
    }
}

