/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.model;

import ru.autosome.perfectosape.model.RegionAffinityVariantInfo;

public class RegionAffinityInfos {
    private final RegionAffinityVariantInfo info_1;
    private final RegionAffinityVariantInfo info_2;

    public RegionAffinityVariantInfo getInfo_1() {
        return this.info_1;
    }

    public RegionAffinityVariantInfo getInfo_2() {
        return this.info_2;
    }

    public RegionAffinityInfos(RegionAffinityVariantInfo info_1, RegionAffinityVariantInfo info_2) {
        this.info_1 = info_1;
        this.info_2 = info_2;
    }

    public double foldChange() {
        return this.info_1.pvalue / this.info_2.pvalue;
    }

    public double logFoldChange() {
        return Math.log(this.info_1.pvalue / this.info_2.pvalue) / Math.log(2.0);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean useLogFoldChange) {
        StringBuilder result = new StringBuilder();
        result.append(this.info_1.position.toString()).append("\t").append(this.info_1.word).append("\t");
        result.append(this.info_2.position.toString()).append("\t").append(this.info_2.word).append("\t");
        result.append(this.info_1.allele).append("/").append(this.info_2.allele).append("\t");
        result.append(this.info_1.pvalue).append("\t").append(this.info_2.pvalue).append("\t");
        if (useLogFoldChange) {
            result.append(this.logFoldChange());
        } else {
            result.append(this.foldChange());
        }
        return result.toString();
    }

    public String toStringShort() {
        return String.format("%.2e", this.info_1.pvalue) + "\t" + String.format("%.2e", this.info_2.pvalue) + "\t" + this.info_1.position.toStringShort() + "\t" + this.info_2.position.toStringShort();
    }

    public boolean hasSiteOnAnyAllele(double max_pvalue_cutoff) {
        return this.info_1.pvalue <= max_pvalue_cutoff || this.info_2.pvalue <= max_pvalue_cutoff;
    }
}

