/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ru.autosome.ape.model.ThresholdPvaluePair;
import ru.autosome.commons.model.BoundaryType;

public class PvalueBsearchList {
    private final List<ThresholdPvaluePair> list;

    public PvalueBsearchList(List<ThresholdPvaluePair> infos) {
        this.list = infos.stream().filter(info -> info.pvalue != 0.0).filter(info -> {
            Double score = info.threshold;
            return !score.isNaN() && !score.isInfinite();
        }).distinct().sorted(ThresholdPvaluePair.thresholdComparator).collect(Collectors.toList());
    }

    public double combine_pvalues(double pvalue_1, double pvalue_2) {
        return Math.sqrt(pvalue_1 * pvalue_2);
    }

    public double pvalue_by_threshold(double threshold) {
        int index = Collections.binarySearch(this.list, new ThresholdPvaluePair(threshold, null), ThresholdPvaluePair.thresholdComparator);
        if (index >= 0) {
            return this.list.get((int)index).pvalue;
        }
        int insertion_point = -index - 1;
        if (insertion_point > 0 && insertion_point < this.list.size()) {
            return this.combine_pvalues(this.list.get((int)insertion_point).pvalue, this.list.get((int)(insertion_point - 1)).pvalue);
        }
        if (insertion_point == 0) {
            return this.list.get((int)0).pvalue;
        }
        return this.list.get((int)(this.list.size() - 1)).pvalue;
    }

    public ThresholdPvaluePair thresholdInfoByPvalue(double pvalue, BoundaryType boundaryType) {
        if (boundaryType == BoundaryType.STRONG) {
            return this.strongThresholdInfoByPvalue(pvalue);
        }
        return this.weakThresholdInfoByPvalue(pvalue);
    }

    private ThresholdPvaluePair strongThresholdInfoByPvalue(double pvalue) {
        int index = Collections.binarySearch(this.list, new ThresholdPvaluePair(null, pvalue), ThresholdPvaluePair.pvalueComparator);
        if (index >= 0) {
            return this.list.get(index);
        }
        int insertion_point = -index - 1;
        if (insertion_point > 0 && insertion_point < this.list.size()) {
            return this.list.get(insertion_point);
        }
        if (insertion_point == 0) {
            return this.list.get(0);
        }
        return this.list.get(this.list.size() - 1);
    }

    private ThresholdPvaluePair weakThresholdInfoByPvalue(double pvalue) {
        int index = Collections.binarySearch(this.list, new ThresholdPvaluePair(null, pvalue), ThresholdPvaluePair.pvalueComparator);
        if (index >= 0) {
            return this.list.get(index);
        }
        int insertion_point = -index - 1;
        if (insertion_point > 0 && insertion_point < this.list.size()) {
            return this.list.get(insertion_point - 1);
        }
        if (insertion_point == 0) {
            return this.list.get(0);
        }
        return this.list.get(this.list.size() - 1);
    }

    public void print_to_stream(Writer fw) throws IOException {
        for (ThresholdPvaluePair info : this.list) {
            fw.write(info + "\n");
        }
        fw.flush();
    }

    public void save_to_file(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        this.print_to_stream(fw);
        fw.close();
    }

    private static List<ThresholdPvaluePair> load_thresholds_list(BufferedReader reader) {
        return reader.lines().map(line -> line.replaceAll("\\s+", "\t").split("\t")).filter(tokens -> ((String[])tokens).length >= 2).map(tokens -> {
            double threshold = Double.valueOf(tokens[0]);
            double pvalue = Double.valueOf(tokens[1]);
            return new ThresholdPvaluePair(threshold, pvalue);
        }).collect(Collectors.toList());
    }

    public static List<ThresholdPvaluePair> load_thresholds_list(File file) throws FileNotFoundException {
        return PvalueBsearchList.load_thresholds_list(new BufferedReader(new FileReader(file)));
    }

    public static PvalueBsearchList load_from_file(File file) throws FileNotFoundException {
        return new PvalueBsearchList(PvalueBsearchList.load_thresholds_list(file));
    }
}

