/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.motifModel.mono;

import ru.autosome.ape.calculation.ScoringModelDistributions.PWMScoresGenerator;
import ru.autosome.ape.calculation.ScoringModelDistributions.ScoringDistributionGenerator;
import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.commons.motifModel.BackgroundAppliable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreBoundaries;
import ru.autosome.commons.motifModel.ScoreDistribution;
import ru.autosome.commons.motifModel.mono.PM;
import ru.autosome.commons.motifModel.types.PositionWeightModel;
import ru.autosome.commons.scoringModel.PWMSequenceScoring;
import ru.autosome.commons.support.ArrayExtensions;

public class PWM
extends PM
implements BackgroundAppliable<BackgroundModel, PWMSequenceScoring>,
Discretable<PWM>,
ScoreDistribution<BackgroundModel>,
PositionWeightModel,
Alignable<PWM>,
ScoreBoundaries {
    private double[] cache_best_suffices;
    private double[] cache_worst_suffices;

    public PWM(double[][] matrix) throws IllegalArgumentException {
        super(matrix);
    }

    @Override
    public double best_score() {
        return this.best_suffix(0);
    }

    @Override
    public double worst_score() {
        return this.worst_suffix(0);
    }

    public double best_suffix(int i) {
        return this.best_suffices()[i];
    }

    double worst_suffix(int i) {
        return this.worst_suffices()[i];
    }

    double[] worst_suffices() {
        if (this.cache_worst_suffices == null) {
            double[] result = new double[this.length() + 1];
            result[this.length()] = 0.0;
            for (int pos_index = this.length() - 1; pos_index >= 0; --pos_index) {
                result[pos_index] = ArrayExtensions.min(this.matrix[pos_index]) + result[pos_index + 1];
            }
            this.cache_worst_suffices = result;
        }
        return this.cache_worst_suffices;
    }

    double[] best_suffices() {
        if (this.cache_best_suffices == null) {
            double[] result = new double[this.length() + 1];
            result[this.length()] = 0.0;
            for (int pos_index = this.length() - 1; pos_index >= 0; --pos_index) {
                result[pos_index] = ArrayExtensions.max(this.matrix[pos_index]) + result[pos_index + 1];
            }
            this.cache_best_suffices = result;
        }
        return this.cache_best_suffices;
    }

    @Override
    public PWM discrete(Discretizer discretizer) {
        return new PWM(this.discretedMatrix(discretizer));
    }

    @Override
    public PWM reverseComplement() {
        double[][] matrix_revcomp = (double[][])ArrayExtensions.reverse(this.matrix);
        for (int i = 0; i < matrix_revcomp.length; ++i) {
            matrix_revcomp[i] = ArrayExtensions.reverse(matrix_revcomp[i]);
        }
        return new PWM(matrix_revcomp);
    }

    @Override
    public PWM leftAugment(int n) {
        double[][] aligned_matrix = new double[this.length() + n][];
        for (int i = 0; i < n; ++i) {
            aligned_matrix[i] = new double[]{0.0, 0.0, 0.0, 0.0};
        }
        System.arraycopy(this.matrix, 0, aligned_matrix, n, this.length());
        return new PWM(aligned_matrix);
    }

    @Override
    public PWM rightAugment(int n) {
        double[][] aligned_matrix = new double[this.length() + n][];
        System.arraycopy(this.matrix, 0, aligned_matrix, 0, this.length());
        for (int i = 0; i < n; ++i) {
            aligned_matrix[this.length() + i] = new double[]{0.0, 0.0, 0.0, 0.0};
        }
        return new PWM(aligned_matrix);
    }

    @Override
    public ScoringDistributionGenerator scoringModel(BackgroundModel background) {
        return new PWMScoresGenerator(this, background);
    }

    @Override
    public PWMSequenceScoring onBackground(BackgroundModel background) {
        return new PWMSequenceScoring(this, background);
    }
}

