/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.calculation.mono;

import gnu.trove.iterator.TDoubleDoubleIterator;
import gnu.trove.iterator.TDoubleObjectIterator;
import gnu.trove.map.hash.TDoubleDoubleHashMap;
import gnu.trove.map.hash.TDoubleObjectHashMap;
import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.motifModel.mono.PWM;
import ru.autosome.macroape.model.PairAligned;

public class AlignedModelIntersection
implements ru.autosome.macroape.calculation.generalized.AlignedModelIntersection {
    public final BackgroundModel background;
    public final PairAligned<PWM> alignment;

    public AlignedModelIntersection(PairAligned<PWM> alignment, BackgroundModel background) {
        this.background = background;
        this.alignment = alignment;
    }

    private TDoubleObjectHashMap<TDoubleDoubleHashMap> initialScoreHash() {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> scores = new TDoubleObjectHashMap<TDoubleDoubleHashMap>();
        scores.put(0.0, new TDoubleDoubleHashMap(new double[]{0.0}, new double[]{1.0}));
        return scores;
    }

    @Override
    public double count_in_intersection(double threshold_first, double threshold_second) {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> scores = this.initialScoreHash();
        for (int pos = 0; pos < this.alignment.length(); ++pos) {
            double[] firstColumn = ((PWM)this.alignment.firstModelAligned).getMatrix()[pos];
            double[] secondColumn = ((PWM)this.alignment.secondModelAligned).getMatrix()[pos];
            double leastSufficientScoreFirst = threshold_first - ((PWM)this.alignment.firstModelAligned).best_suffix(pos + 1);
            double leastSufficientScoreSecond = threshold_second - ((PWM)this.alignment.secondModelAligned).best_suffix(pos + 1);
            scores = this.background.is_wordwise() ? this.recalc_score_hash_wordwise(scores, firstColumn, secondColumn, leastSufficientScoreFirst, leastSufficientScoreSecond) : this.recalc_score_hash(scores, firstColumn, secondColumn, leastSufficientScoreFirst, leastSufficientScoreSecond, this.background);
        }
        return this.combine_scores(scores);
    }

    double combine_scores(TDoubleObjectHashMap<TDoubleDoubleHashMap> scores) {
        double sum = 0.0;
        TDoubleObjectIterator<TDoubleDoubleHashMap> iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            TDoubleDoubleIterator second_iterator = iterator.value().iterator();
            while (second_iterator.hasNext()) {
                second_iterator.advance();
                sum += second_iterator.value();
            }
        }
        return sum;
    }

    TDoubleObjectHashMap<TDoubleDoubleHashMap> seedHashToRecalc(TDoubleObjectHashMap<TDoubleDoubleHashMap> scores, double[] firstColumn, double leastSufficientScoreFirst) {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> result = new TDoubleObjectHashMap<TDoubleDoubleHashMap>();
        TDoubleObjectIterator<TDoubleDoubleHashMap> iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double score_first = iterator.key();
            for (int letter = 0; letter < 4; ++letter) {
                double new_score_first = score_first + firstColumn[letter];
                if (!(new_score_first >= leastSufficientScoreFirst)) continue;
                result.put(new_score_first, new TDoubleDoubleHashMap());
            }
        }
        return result;
    }

    TDoubleObjectHashMap<TDoubleDoubleHashMap> recalc_score_hash(TDoubleObjectHashMap<TDoubleDoubleHashMap> scores, double[] firstColumn, double[] secondColumn, double leastSufficientScoreFirst, double leastSufficientScoreSecond, BackgroundModel background) {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> new_scores = this.seedHashToRecalc(scores, firstColumn, leastSufficientScoreFirst);
        TDoubleObjectIterator<TDoubleDoubleHashMap> iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double score_first = iterator.key();
            TDoubleDoubleHashMap second_scores = iterator.value();
            TDoubleDoubleIterator second_iterator = second_scores.iterator();
            while (second_iterator.hasNext()) {
                second_iterator.advance();
                double score_second = second_iterator.key();
                double count = second_iterator.value();
                for (int letter = 0; letter < 4; ++letter) {
                    double new_score_second;
                    double new_score_first = score_first + firstColumn[letter];
                    if (!(new_score_first >= leastSufficientScoreFirst) || !((new_score_second = score_second + secondColumn[letter]) >= leastSufficientScoreSecond)) continue;
                    double add = background.count(letter) * count;
                    new_scores.get(new_score_first).adjustOrPutValue(new_score_second, add, add);
                }
            }
        }
        return new_scores;
    }

    TDoubleObjectHashMap<TDoubleDoubleHashMap> recalc_score_hash_wordwise(TDoubleObjectHashMap<TDoubleDoubleHashMap> scores, double[] firstColumn, double[] secondColumn, double leastSufficientScoreFirst, double leastSufficientScoreSecond) {
        TDoubleObjectHashMap<TDoubleDoubleHashMap> new_scores = this.seedHashToRecalc(scores, firstColumn, leastSufficientScoreFirst);
        TDoubleObjectIterator<TDoubleDoubleHashMap> iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double score_first = iterator.key();
            TDoubleDoubleHashMap second_scores = iterator.value();
            TDoubleDoubleIterator second_iterator = second_scores.iterator();
            while (second_iterator.hasNext()) {
                second_iterator.advance();
                double score_second = second_iterator.key();
                double count = second_iterator.value();
                for (int letter = 0; letter < 4; ++letter) {
                    double new_score_second;
                    double new_score_first = score_first + firstColumn[letter];
                    if (!(new_score_first >= leastSufficientScoreFirst) || !((new_score_second = score_second + secondColumn[letter]) >= leastSufficientScoreSecond)) continue;
                    new_scores.get(new_score_first).adjustOrPutValue(new_score_second, count, count);
                }
            }
        }
        return new_scores;
    }
}

