/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.ScoringModelDistributions;

import gnu.trove.map.TDoubleDoubleMap;
import java.util.List;
import ru.autosome.ape.calculation.findThreshold.FoundedThresholdInfo;
import ru.autosome.ape.calculation.findThreshold.GaussianThresholdEstimator;
import ru.autosome.ape.model.ScoreDistributionTop;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.support.ArrayExtensions;

public abstract class ScoringDistributionGenerator {
    abstract GaussianThresholdEstimator gaussianThresholdEstimator();

    protected abstract ScoreDistributionTop score_distribution_above_threshold(double var1);

    private ScoreDistributionTop score_distribution() {
        return this.score_distribution_above_threshold(Double.NEGATIVE_INFINITY);
    }

    private ScoreDistributionTop score_distribution_under_pvalue(double pvalue) {
        int maxNumberOfAttempts = 2;
        int numberOfAttempts = 0;
        GaussianThresholdEstimator gaussianThresholdEstimation = this.gaussianThresholdEstimator();
        double pvalue_to_estimate_threshold = pvalue;
        try {
            ScoreDistributionTop scoreDistribution;
            do {
                if (++numberOfAttempts > 2) {
                    return this.score_distribution();
                }
                double approximate_threshold = gaussianThresholdEstimation.thresholdByPvalue(pvalue_to_estimate_threshold);
                scoreDistribution = this.score_distribution_above_threshold(approximate_threshold);
                pvalue_to_estimate_threshold *= 2.0;
            } while (scoreDistribution.top_part_pvalue() < pvalue);
            return scoreDistribution;
        }
        catch (ArithmeticException e) {
            return this.score_distribution();
        }
    }

    public TDoubleDoubleMap counts_above_thresholds(List<Double> thresholds) {
        ScoreDistributionTop scoreDistribution = this.score_distribution_above_threshold(ArrayExtensions.min(thresholds));
        try {
            return scoreDistribution.counts_above_thresholds(thresholds);
        }
        catch (ScoreDistributionTop.NotRepresentativeDistribution exception) {
            throw new RuntimeException("Should never be here", exception);
        }
    }

    public List<FoundedThresholdInfo> thresholds(List<Double> pvalues, BoundaryType pvalueBoundary) {
        ScoreDistributionTop scores_hash = this.score_distribution_under_pvalue(ArrayExtensions.max(pvalues));
        try {
            return scores_hash.thresholds(pvalues, pvalueBoundary);
        }
        catch (ScoreDistributionTop.NotRepresentativeDistribution exception) {
            throw new RuntimeException("Should never be here", exception);
        }
    }

    public FoundedThresholdInfo threshold(double pvalue, BoundaryType pvalueBoundary) {
        ScoreDistributionTop scores_hash = this.score_distribution_under_pvalue(pvalue);
        try {
            return scores_hash.threshold(pvalue, pvalueBoundary);
        }
        catch (ScoreDistributionTop.NotRepresentativeDistribution exception) {
            throw new RuntimeException("Should never be here", exception);
        }
    }
}

