/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.findPvalue;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FoundedPvalueInfo;
import ru.autosome.ape.model.PvalueBsearchList;
import ru.autosome.commons.cli.ReportListLayout;

public class FindPvalueBsearch
implements CanFindPvalue {
    final PvalueBsearchList bsearchList;

    public FindPvalueBsearch(PvalueBsearchList bsearchList) {
        this.bsearchList = bsearchList;
    }

    public FindPvalueBsearch(File thresholds_file) throws FileNotFoundException {
        this.bsearchList = PvalueBsearchList.load_from_file(thresholds_file);
    }

    @Override
    public List<FoundedPvalueInfo> pvaluesByThresholds(List<Double> thresholds) {
        ArrayList<FoundedPvalueInfo> results = new ArrayList<FoundedPvalueInfo>();
        for (double threshold : thresholds) {
            results.add(this.pvalueByThreshold(threshold));
        }
        return results;
    }

    @Override
    public FoundedPvalueInfo pvalueByThreshold(double threshold) {
        double pvalue = this.bsearchList.pvalue_by_threshold(threshold);
        return new FoundedPvalueInfo(threshold, pvalue);
    }

    @Override
    public ReportListLayout<FoundedPvalueInfo> report_table_layout() {
        ReportListLayout<FoundedPvalueInfo> infos = new ReportListLayout<FoundedPvalueInfo>();
        infos.add_table_parameter("T", "threshold", cell -> cell.threshold);
        infos.add_table_parameter("P", "P-value", cell -> cell.pvalue);
        return infos;
    }
}

