/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.cli.generalized;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.ape.calculation.findThreshold.FindThresholdBsearch;
import ru.autosome.ape.calculation.findThreshold.FoundedThresholdInfo;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.Helper;
import ru.autosome.commons.cli.ReportListLayout;
import ru.autosome.commons.cli.TextListReporter;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.types.DataModel;
import ru.autosome.commons.support.IOExtensions;

public abstract class FindThreshold<ModelType extends HasLength, BackgroundType extends GeneralizedBackgroundModel> {
    protected Discretizer discretizer;
    protected BoundaryType pvalue_boundary;
    protected List<Double> pvalues;
    protected boolean transpose;
    protected boolean should_extract_values_from_stdin;
    protected String pm_filename;
    protected DataModel data_model;
    protected double effective_count;
    protected PseudocountCalculator pseudocount;
    protected BackgroundType background;
    protected Named<ModelType> motif;
    protected File thresholds_folder;

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <pat-file> [<list of P-values>...] [options]\n\nOptions:\n  [--discretization <discretization level>] or [-d]\n  [--pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [--boundary lower|upper] Lower boundary (default) means that the obtained P-value is less than or equal to the requested P-value\n  [--background <background probabilities>] or [-b] " + this.DOC_background_option() + "\n  [--precalc <folder>] - specify folder with thresholds for PWM collection (for fast-and-rough calculation).\n  [--transpose] - load motif from transposed matrix (nucleotides in lines).\n" + this.DOC_additional_options() + "\nExamples:\n  " + this.DOC_run_string() + " motifs/diKLF4_f2.pat\n  " + this.DOC_run_string() + "  motifs/diKLF4_f2.pat 0.001 0.0001 0.0005 -d 1000 -b 0.4,0.3,0.2,0.1\n";
    }

    protected String DOC_additional_options() {
        return "";
    }

    protected abstract void initialize_default_background();

    protected abstract void extract_background(String var1);

    protected abstract Named<ModelType> loadMotif(String var1);

    protected abstract CanFindThreshold calculator() throws FileNotFoundException;

    protected CanFindThreshold bsearchCalculator() throws FileNotFoundException {
        if (this.thresholds_folder.isFile()) {
            return new FindThresholdBsearch(this.thresholds_folder);
        }
        File thresholds_file = new File(this.thresholds_folder, this.motif.getName() + ".thr");
        return new FindThresholdBsearch(thresholds_file);
    }

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.discretizer = new Discretizer(10000.0);
        this.pvalue_boundary = BoundaryType.STRONG;
        this.data_model = DataModel.PWM;
        this.effective_count = 100.0;
        this.pseudocount = PseudocountCalculator.logPseudocount;
        this.thresholds_folder = null;
        this.transpose = false;
        this.should_extract_values_from_stdin = false;
        this.pvalues = new ArrayList<Double>();
        this.pvalues.add(5.0E-4);
    }

    protected void setup_from_arglist(List<String> argv) throws IOException {
        Helper.print_help_if_requested(argv, this.documentString());
        this.extract_pm_filename(argv);
        if (argv.contains("--pvalues-from-stdin")) {
            this.should_extract_values_from_stdin = true;
        }
        this.extract_pvalue_list(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.motif = this.loadMotif(this.pm_filename);
    }

    protected void setup_from_arglist(String[] args) throws IOException {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        this.setup_from_arglist(argv);
    }

    protected void extract_option(List<String> argv) throws FileNotFoundException {
        String opt = argv.remove(0);
        if (opt.equals("-b") || opt.equals("--background")) {
            this.extract_background(argv.remove(0));
        } else if (opt.equals("-d") || opt.equals("--discretization")) {
            this.discretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalue_boundary = BoundaryType.fromString(argv.remove(0));
        } else if (opt.equals("--pcm")) {
            this.data_model = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.data_model = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            this.effective_count = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pseudocount")) {
            this.pseudocount = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--precalc")) {
            this.thresholds_folder = new File(argv.remove(0));
            if (!this.thresholds_folder.exists()) {
                throw new FileNotFoundException("Specified file/folder with thresholds `" + this.thresholds_folder + "` not exists");
            }
        } else if (opt.equals("--transpose")) {
            this.transpose = true;
        } else if (!opt.equals("--pvalues-from-stdin") && this.failed_to_recognize_additional_options(opt, argv)) {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        return true;
    }

    protected void extract_pm_filename(List<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.pm_filename = argv.remove(0);
    }

    protected void extract_pvalue_list(List<String> argv) throws IOException {
        ArrayList<Double> pvalues_tmp = new ArrayList<Double>();
        try {
            while (!argv.isEmpty()) {
                pvalues_tmp.add(Double.valueOf(argv.get(0)));
                argv.remove(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.should_extract_values_from_stdin) {
            IOExtensions.extract_doubles_from_input_stream(System.in, pvalues_tmp);
        }
        if (pvalues_tmp.size() != 0) {
            this.pvalues = pvalues_tmp;
        }
    }

    ReportListLayout<FoundedThresholdInfo> report_table_layout() {
        ReportListLayout<FoundedThresholdInfo> infos = new ReportListLayout<FoundedThresholdInfo>();
        infos.add_parameter("V", "discretization value", this.discretizer);
        infos.add_parameter("PB", "P-value boundary", (Object)this.pvalue_boundary);
        infos.background_parameter("B", "background", (GeneralizedBackgroundModel)this.background);
        infos.add_table_parameter("P", "requested P-value", cell -> cell.expected_pvalue);
        infos.add_table_parameter("AP", "actual P-value", cell -> cell.real_pvalue);
        if (this.background.is_wordwise()) {
            infos.add_table_parameter("W", "number of recognized words", cell -> {
                double numberOfRecognizedWords = cell.numberOfRecognizedWords(this.background.volume(), ((HasLength)this.motif.getObject()).length());
                return (long)numberOfRecognizedWords;
            });
        }
        infos.add_table_parameter("T", "threshold", cell -> cell.threshold);
        return infos;
    }

    protected String report() throws FileNotFoundException {
        CanFindThreshold calc = this.calculator();
        List<FoundedThresholdInfo> results = calc.thresholdsByPvalues(this.pvalues, this.pvalue_boundary);
        ReportListLayout<FoundedThresholdInfo> layout = this.report_table_layout();
        TextListReporter<FoundedThresholdInfo> reporter = new TextListReporter<FoundedThresholdInfo>();
        return reporter.report(results, layout);
    }

    protected FindThreshold() {
        this.initialize_defaults();
    }
}

