/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.converter.generalized;

import ru.autosome.commons.converter.generalized.MotifConverter;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.motifModel.types.PositionCountModel;
import ru.autosome.commons.motifModel.types.PositionFrequencyModel;

public abstract class PPM2PCM<ModelTypeFrom extends PositionFrequencyModel, ModelTypeTo extends PositionCountModel>
implements MotifConverter<ModelTypeFrom, ModelTypeTo> {
    public final double count;

    protected abstract ModelTypeTo createMotif(double[][] var1);

    public PPM2PCM(double count) {
        this.count = count;
    }

    @Override
    public Named<ModelTypeTo> convert(Named<ModelTypeFrom> namedModel) {
        return new Named<ModelTypeTo>(this.convert((ModelTypeFrom)((PositionFrequencyModel)namedModel.getObject())), namedModel.getName());
    }

    @Override
    public ModelTypeTo convert(ModelTypeFrom ppm) {
        double[][] new_matrix = new double[ppm.getMatrix().length][];
        for (int pos = 0; pos < ppm.getMatrix().length; ++pos) {
            new_matrix[pos] = this.convert_position(ppm.getMatrix()[pos]);
        }
        return this.createMotif(new_matrix);
    }

    private double[] convert_position(double[] pos) {
        double[] converted_pos = new double[pos.length];
        for (int letter = 0; letter < pos.length; ++letter) {
            converted_pos[letter] = pos[letter] * this.count;
        }
        return converted_pos;
    }
}

