/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.importer;

import java.util.List;
import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.importer.ChIPMunkParser;
import ru.autosome.commons.importer.MotifImporter;
import ru.autosome.commons.importer.NormalMatrixParser;
import ru.autosome.commons.importer.ParsingResult;
import ru.autosome.commons.importer.TransposedMatrixParser;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.di.DiPCM;
import ru.autosome.commons.motifModel.di.DiPPM;
import ru.autosome.commons.motifModel.di.DiPWM;
import ru.autosome.commons.motifModel.types.DataModel;
import ru.autosome.commons.support.StringExtensions;

public class DiPWMImporter
extends MotifImporter<DiPWM> {
    final DataModel dataModel;
    final Double effectiveCount;
    final PseudocountCalculator pseudocountCalculator;
    final DiBackgroundModel background;
    final boolean transpose;

    public DiPWMImporter() {
        this.dataModel = DataModel.PWM;
        this.effectiveCount = null;
        this.pseudocountCalculator = PseudocountCalculator.logPseudocount;
        this.background = null;
        this.transpose = false;
    }

    public DiPWMImporter(DiBackgroundModel background, DataModel dataModel, Double effectiveCount, boolean transpose, PseudocountCalculator pseudocount) {
        this.dataModel = dataModel;
        this.effectiveCount = effectiveCount;
        this.pseudocountCalculator = pseudocount;
        this.background = background;
        this.transpose = transpose;
    }

    @Override
    public DiPWM createMotif(double[][] matrix) {
        DiPWM dipwm;
        switch (this.dataModel) {
            case PCM: {
                dipwm = new DiPCM(matrix).to_pwm(this.background, this.pseudocountCalculator);
                break;
            }
            case PPM: {
                dipwm = new DiPPM(matrix).to_pwm(this.background, this.effectiveCount, this.pseudocountCalculator);
                break;
            }
            case PWM: {
                dipwm = new DiPWM(matrix);
                break;
            }
            default: {
                throw new Error("This code never reached");
            }
        }
        return dipwm;
    }

    @Override
    public ParsingResult parse(List<String> strings) {
        if (StringExtensions.startWith(strings.get(0), "PROG|ru.autosome.di.ChIPMunk")) {
            return new ChIPMunkParser(16, "ru.autosome.di.ChIPMunk", "PWAA").parse(strings);
        }
        if (this.transpose) {
            return new TransposedMatrixParser(16).parse(strings);
        }
        return new NormalMatrixParser(16).parse(strings);
    }
}

