/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class InputExtensions {
    public static List<String> readLinesFromFile(File file) throws FileNotFoundException {
        FileInputStream reader = new FileInputStream(file);
        return InputExtensions.readLinesFromInputStream(reader);
    }

    public static List<String> readLinesFromInputStream(InputStream in) {
        String newline = System.getProperty("line.separator");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        return reader.lines().map(line -> line + newline).collect(Collectors.toList());
    }

    public static boolean startWithDouble(String s) {
        return InputExtensions.isDouble(s.replaceAll("\\s+", " ").split(" ")[0]);
    }

    public static boolean isDouble(String s) {
        try {
            Double.valueOf(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static List<String> beforeEmptyLine(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            if (line.trim().isEmpty()) {
                return result;
            }
            result.add(line);
        }
        return result;
    }

    public static List<String> trimAll(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>(lines.size());
        for (String line : lines) {
            result.add(line.trim());
        }
        return result;
    }

    public static List<Double> listOfDoubleTokens(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, ",");
        ArrayList<Double> tokens = new ArrayList<Double>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(Double.valueOf(tokenizer.nextToken()));
        }
        return tokens;
    }
}

