/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.model;

import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.model.PositionInterval;

public class Position {
    protected final int position;
    protected final Orientation orientation;

    public Position(int position, Orientation orientation) {
        this.position = position;
        this.orientation = orientation;
    }

    public Position(int position, String strand) {
        this.position = position;
        this.orientation = Orientation.valueOf(strand);
    }

    public static PositionInterval positions_between(int pos_left, int pos_right, int subseq_length) {
        return new PositionInterval(pos_left, pos_right - subseq_length);
    }

    public int position() {
        return this.position;
    }

    public Orientation orientation() {
        return this.orientation;
    }

    public boolean isDirect() {
        return this.orientation.isDirect();
    }

    public boolean isReverseComplement() {
        return this.orientation.isReverseComplement();
    }

    public String toString() {
        return String.valueOf(this.position) + "\t" + (Object)((Object)this.orientation);
    }

    public String toStringShort() {
        return String.valueOf(this.position) + "\t" + this.orientation.toStringShort();
    }
}

