/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.model;

import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.scoringModel.SequenceScoringModel;
import ru.autosome.perfectosape.model.PositionWithScore;

public class PositionInterval {
    public final int left;
    public final int right;

    PositionInterval(int left, int right) {
        if (left >= right) {
            throw new IllegalArgumentException("Left should be less than right");
        }
        this.left = left;
        this.right = right;
    }

    public <SequenceType extends HasLength> PositionWithScore findBestPosition(SequenceType sequence, SequenceScoringModel<SequenceType> sequenceScoringModel) {
        PositionWithScore bestPos = new PositionWithScore();
        for (int pos = Math.max(this.left, 0); pos <= Math.min(this.right, sequence.length() - sequenceScoringModel.length()); ++pos) {
            bestPos.replaceIfBetter(pos, Orientation.direct, sequenceScoringModel.score(sequence, Orientation.direct, pos));
            bestPos.replaceIfBetter(pos, Orientation.revcomp, sequenceScoringModel.score(sequence, Orientation.revcomp, pos));
        }
        return bestPos;
    }

    public String toString() {
        return "[" + this.left + ";" + this.right + "]";
    }

    public PositionInterval expand(int expandRegionLength) {
        return new PositionInterval(this.left - expandRegionLength, this.right + expandRegionLength);
    }
}

