/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.motifModel.di;

import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.converter.di.PCM2PPM;
import ru.autosome.commons.converter.di.PCM2PWM;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.di.DiPM;
import ru.autosome.commons.motifModel.di.DiPPM;
import ru.autosome.commons.motifModel.di.DiPWM;
import ru.autosome.commons.motifModel.types.PositionCountModel;

public class DiPCM
extends DiPM
implements PositionCountModel {
    public DiPCM(double[][] matrix) throws IllegalArgumentException {
        super(matrix);
    }

    public double count() {
        double[] pos = this.getMatrix()[0];
        double sum = 0.0;
        for (int i = 0; i < this.alphabetSize(); ++i) {
            sum += pos[i];
        }
        return sum;
    }

    public DiPWM to_pwm(DiBackgroundModel background, PseudocountCalculator pseudocount) {
        return (DiPWM)new PCM2PWM(background, pseudocount).convert(this);
    }

    public DiPPM to_ppm() {
        return (DiPPM)new PCM2PPM().convert(this);
    }
}

