/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.motifModel.di;

import ru.autosome.ape.calculation.ScoringModelDistributions.DiPWMScoresGenerator;
import ru.autosome.ape.calculation.ScoringModelDistributions.ScoringDistributionGenerator;
import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.indexingScheme.DiIndexingScheme;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.commons.motifModel.BackgroundAppliable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreBoundaries;
import ru.autosome.commons.motifModel.ScoreDistribution;
import ru.autosome.commons.motifModel.di.DiPM;
import ru.autosome.commons.motifModel.mono.PWM;
import ru.autosome.commons.motifModel.types.PositionWeightModel;
import ru.autosome.commons.scoringModel.DiPWMSequenceScoring;

public class DiPWM
extends DiPM
implements BackgroundAppliable<DiBackgroundModel, DiPWMSequenceScoring>,
Discretable<DiPWM>,
ScoreDistribution<DiBackgroundModel>,
PositionWeightModel,
Alignable<DiPWM>,
ScoreBoundaries {
    private double[][] cache_best_suffices;
    private double[][] cache_worst_suffices;

    public DiPWM(double[][] matrix) {
        super(matrix);
    }

    public static DiPWM fromPWM(PWM pwm) {
        double[][] matrix = new double[pwm.getMatrix().length - 1][];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = new double[16];
            for (int letter = 0; letter < 16; ++letter) {
                matrix[i][letter] = pwm.getMatrix()[i][DiIndexingScheme.firstLetterIndex(letter)];
            }
        }
        for (int letter = 0; letter < 16; ++letter) {
            double[] dArray = matrix[matrix.length - 1];
            int n = letter;
            dArray[n] = dArray[n] + pwm.getMatrix()[matrix.length][DiIndexingScheme.secondLetterIndex(letter)];
        }
        return new DiPWM(matrix);
    }

    @Override
    public double best_score() {
        double best_score = Double.NEGATIVE_INFINITY;
        for (int letter = 0; letter < 4; ++letter) {
            best_score = Math.max(best_score, this.best_suffix(0, letter));
        }
        return best_score;
    }

    @Override
    public double worst_score() {
        double worst_score = Double.POSITIVE_INFINITY;
        for (int letter = 0; letter < 4; ++letter) {
            worst_score = Math.min(worst_score, this.worst_suffix(0, letter));
        }
        return worst_score;
    }

    public double best_suffix(int pos, int letter) {
        return this.best_suffices()[pos][letter];
    }

    public double worst_suffix(int pos, int letter) {
        return this.worst_suffices()[pos][letter];
    }

    private double[][] best_suffices() {
        if (this.cache_best_suffices == null) {
            this.cache_best_suffices = this.calculate_best_suffices();
        }
        return this.cache_best_suffices;
    }

    private double[][] worst_suffices() {
        if (this.cache_worst_suffices == null) {
            this.cache_worst_suffices = this.calculate_worst_suffices();
        }
        return this.cache_worst_suffices;
    }

    private double[][] calculate_best_suffices() {
        double[][] result = new double[this.matrix.length + 1][];
        for (int letter = 0; letter < 4; ++letter) {
            result[this.matrix.length] = new double[16];
            result[this.matrix.length][letter] = 0.0;
        }
        for (int i = this.matrix.length - 1; i >= 0; --i) {
            result[i] = new double[16];
            for (int letter = 0; letter < 4; ++letter) {
                double best_score = Double.NEGATIVE_INFINITY;
                for (int next_letter = 0; next_letter < 4; ++next_letter) {
                    best_score = Math.max(best_score, this.matrix[i][DiIndexingScheme.diIndex(letter, next_letter)] + result[i + 1][next_letter]);
                }
                result[i][letter] = best_score;
            }
        }
        return result;
    }

    private double[][] calculate_worst_suffices() {
        double[][] result = new double[this.matrix.length + 1][];
        for (int letter = 0; letter < 4; ++letter) {
            result[this.matrix.length] = new double[16];
            result[this.matrix.length][letter] = 0.0;
        }
        for (int i = this.matrix.length - 1; i >= 0; --i) {
            result[i] = new double[16];
            for (int letter = 0; letter < 4; ++letter) {
                double worst_score = Double.POSITIVE_INFINITY;
                for (int next_letter = 0; next_letter < 4; ++next_letter) {
                    worst_score = Math.min(worst_score, this.matrix[i][DiIndexingScheme.diIndex(letter, next_letter)] + result[i + 1][next_letter]);
                }
                result[i][letter] = worst_score;
            }
        }
        return result;
    }

    @Override
    public DiPWM discrete(Discretizer discretizer) {
        return new DiPWM(this.discretizedMatrix(discretizer));
    }

    @Override
    public ScoringDistributionGenerator scoringModel(DiBackgroundModel background) {
        return new DiPWMScoresGenerator(this, background);
    }

    @Override
    public DiPWM reverseComplement() {
        double[][] matrix_revcomp = new double[this.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            matrix_revcomp[i] = new double[16];
            for (int di_index = 0; di_index < 16; ++di_index) {
                matrix_revcomp[i][di_index] = this.matrix[this.matrix.length - 1 - i][DiIndexingScheme.complementDinucleotideIndex(di_index)];
            }
        }
        return new DiPWM(matrix_revcomp);
    }

    @Override
    public DiPWM leftAugment(int n) {
        double[][] aligned_matrix = new double[this.matrix.length + n][];
        for (int i = 0; i < n; ++i) {
            aligned_matrix[i] = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        }
        System.arraycopy(this.matrix, 0, aligned_matrix, n, this.matrix.length);
        return new DiPWM(aligned_matrix);
    }

    @Override
    public DiPWM rightAugment(int n) {
        double[][] aligned_matrix = new double[this.matrix.length + n][];
        System.arraycopy(this.matrix, 0, aligned_matrix, 0, this.matrix.length);
        for (int i = 0; i < n; ++i) {
            aligned_matrix[this.matrix.length + i] = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        }
        return new DiPWM(aligned_matrix);
    }

    @Override
    public DiPWMSequenceScoring onBackground(DiBackgroundModel background) {
        return new DiPWMSequenceScoring(this, background);
    }
}

