/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.scoringModel;

import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.motifModel.ScoreStatistics;
import ru.autosome.commons.motifModel.mono.PWM;
import ru.autosome.commons.scoringModel.SequenceScoringModel;
import ru.autosome.perfectosape.model.encoded.mono.SequenceMonoEncoded;

public class PWMSequenceScoring
implements ScoreStatistics,
SequenceScoringModel<SequenceMonoEncoded> {
    private final PWM pwm;
    private final BackgroundModel background;
    private final double[][] matrixIUPAC;
    private final int length;

    public PWMSequenceScoring(PWM pwm, BackgroundModel background) {
        this.pwm = pwm;
        this.background = background;
        this.matrixIUPAC = this.calculateMatrixIUPAC();
        this.length = pwm.length();
    }

    private double[][] calculateMatrixIUPAC() {
        double[][] result = new double[this.pwm.length()][];
        for (int posIndex = 0; posIndex < this.pwm.length(); ++posIndex) {
            result[posIndex] = new double[5];
            System.arraycopy(this.pwm.getMatrix()[posIndex], 0, result[posIndex], 0, 4);
            result[posIndex][4] = this.background.mean_value(this.pwm.getMatrix()[posIndex]);
        }
        return result;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double score(SequenceMonoEncoded word) {
        return this.score(word, Orientation.direct, 0);
    }

    @Override
    public double score(SequenceMonoEncoded word, Orientation orientation, int position) {
        int startPos;
        byte[] seq;
        if (orientation == Orientation.direct) {
            seq = word.directSequence;
            startPos = position;
        } else {
            seq = word.revcompSequence;
            startPos = seq.length - (position + this.length());
        }
        double sum = 0.0;
        for (int pos_index = 0; pos_index < this.length(); ++pos_index) {
            byte letter = seq[startPos + pos_index];
            sum += this.matrixIUPAC[pos_index][letter];
        }
        return sum;
    }

    @Override
    public double score_mean() {
        double result = 0.0;
        for (double[] pos : this.pwm.getMatrix()) {
            result += this.background.mean_value(pos);
        }
        return result;
    }

    @Override
    public double score_variance() {
        double variance = 0.0;
        for (double[] pos : this.pwm.getMatrix()) {
            variance += this.background.variance(pos);
        }
        return variance;
    }
}

