/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.calculation.generalized;

import java.util.function.Function;
import ru.autosome.ape.calculation.findPvalue.FoundedPvalueInfo;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.macroape.calculation.generalized.AlignedModelIntersection;
import ru.autosome.macroape.calculation.generalized.CompareModelsExact;
import ru.autosome.macroape.model.ComparisonSimilarityInfo;
import ru.autosome.macroape.model.PairAligned;

public class CompareModels<ModelType extends Alignable<ModelType> & Discretable<ModelType>> {
    private final Discretizer discretizer;
    private final CompareModelsExact<ModelType> evaluator;

    public CompareModels(ModelType firstPWM, ModelType secondPWM, int backgroundVolume, Discretizer discretizer, Function<PairAligned<ModelType>, ? extends AlignedModelIntersection> calculatorOfAligned) {
        this.discretizer = discretizer;
        this.evaluator = new CompareModelsExact<Alignable>((Alignable)((Discretable)firstPWM).discrete(discretizer), (Alignable)((Discretable)secondPWM).discrete(discretizer), backgroundVolume, calculatorOfAligned);
    }

    public ComparisonSimilarityInfo jaccard(FoundedPvalueInfo first, FoundedPvalueInfo second) {
        return this.evaluator.jaccard(first.upscale(this.discretizer), second.upscale(this.discretizer));
    }

    public ComparisonSimilarityInfo jaccardFixedStrand(FoundedPvalueInfo first, FoundedPvalueInfo second, Orientation strand) {
        return this.evaluator.jaccardFixedStrand(first.upscale(this.discretizer), second.upscale(this.discretizer), strand);
    }

    public ComparisonSimilarityInfo jaccardAtPosition(FoundedPvalueInfo first, FoundedPvalueInfo second, Position position) {
        return this.evaluator.jaccardAtPosition(first.upscale(this.discretizer), second.upscale(this.discretizer), position);
    }
}

