/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.cli.generalized;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import ru.autosome.ape.calculation.findPvalue.FindPvalueAPE;
import ru.autosome.ape.calculation.findPvalue.FoundedPvalueInfo;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.Helper;
import ru.autosome.commons.cli.ReportLayout;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreDistribution;
import ru.autosome.commons.motifModel.types.DataModel;
import ru.autosome.macroape.calculation.generalized.AlignedModelIntersection;
import ru.autosome.macroape.calculation.generalized.CompareModels;
import ru.autosome.macroape.model.ComparisonSimilarityInfo;
import ru.autosome.macroape.model.PairAligned;

public abstract class EvalSimilarity<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected BackgroundType background;
    protected Discretizer discretizer;
    protected double pvalue;
    protected BoundaryType pvalueBoundary;
    protected String firstPMFilename;
    protected String secondPMFilename;
    protected DataModel dataModelFirst;
    protected DataModel dataModelSecond;
    protected PseudocountCalculator pseudocountFirst;
    protected PseudocountCalculator pseudocountSecond;
    protected Double effectiveCountFirst;
    protected Double effectiveCountSecond;
    protected Double predefinedFirstThreshold;
    protected Double predefinedSecondThreshold;
    protected ModelType firstPWM;
    protected ModelType secondPWM;
    protected Double cacheFirstThreshold;
    protected Double cacheSecondThreshold;
    private Position relativePosition;
    private Orientation fixedStrand;
    protected boolean transposeFirst;
    protected boolean transposeSecond;

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected String DOC_additional_options() {
        return "";
    }

    protected EvalSimilarity() {
        this.initialize_defaults();
    }

    protected String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <1st matrix pat-file> <2nd matrix pat-file> [options]\n\nOptions:\n  [--pvalue <P-value>] or [-p]\n  [--discretization <discretization level>] or [-d]\n  [--[first-|second-]pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--[first-|second-]ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--[first-|second-]effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n  [--background <background probabilities>] or [-b] " + this.DOC_background_option() + "\n  [--first-threshold <threshold for the first matrix>]\n  [--second-threshold <threshold for the second matrix>]\n  [--position <shift>,<direct|revcomp>] - specify relative alignment to test. By default every alignment tested (example: --position -3,revcomp).\n                                          --position all,<direct|revcomp> allows to scan all positions on the fixed strand.\n  [--[first-|second-]transpose] - load motif from transposed matrix (nucleotides in lines).\n" + this.DOC_additional_options() + "\nExamples:\n  " + this.DOC_run_string() + " motifs/KLF4_f2.pat motifs/SP1_f1.pat -p 0.0005 -d 100 -b 0.3,0.2,0.2,0.3\n";
    }

    protected abstract BackgroundType extract_background(String var1);

    protected abstract ModelType loadFirstPWM(String var1);

    protected abstract ModelType loadSecondPWM(String var1);

    protected abstract Function<PairAligned<ModelType>, ? extends AlignedModelIntersection> calc_alignment();

    protected void setup_from_arglist(String[] args) {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        this.setup_from_arglist(argv);
    }

    protected void setup_from_arglist(List<String> argv) {
        Helper.print_help_if_requested(argv, this.documentString());
        this.extract_first_pm_filename(argv);
        this.extract_second_pm_filename(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.firstPWM = this.loadFirstPWM(this.firstPMFilename);
        this.secondPWM = this.loadSecondPWM(this.secondPMFilename);
    }

    protected void extract_first_pm_filename(List<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.firstPMFilename = argv.remove(0);
    }

    protected void extract_second_pm_filename(List<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.secondPMFilename = argv.remove(0);
    }

    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        return true;
    }

    protected abstract void initialize_default_background();

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.dataModelFirst = DataModel.PWM;
        this.dataModelSecond = DataModel.PWM;
        this.effectiveCountFirst = 100.0;
        this.effectiveCountSecond = 100.0;
        this.pseudocountFirst = PseudocountCalculator.logPseudocount;
        this.pseudocountSecond = PseudocountCalculator.logPseudocount;
        this.pvalue = 5.0E-4;
        this.discretizer = new Discretizer(10.0);
        this.transposeFirst = false;
        this.transposeSecond = false;
        this.pvalueBoundary = BoundaryType.WEAK;
        this.relativePosition = null;
        this.fixedStrand = null;
    }

    protected void extract_option(List<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b") || opt.equals("--background")) {
            this.background = this.extract_background(argv.remove(0));
        } else if (opt.equals("-p") || opt.equals("--pvalue")) {
            this.pvalue = Double.valueOf(argv.remove(0));
        } else if (opt.equals("-d") || opt.equals("--discretization")) {
            this.discretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalueBoundary = BoundaryType.fromString(argv.remove(0));
        } else if (opt.equals("--pcm")) {
            this.dataModelFirst = DataModel.PCM;
            this.dataModelSecond = DataModel.PCM;
        } else if (opt.equals("--first-pcm")) {
            this.dataModelFirst = DataModel.PCM;
        } else if (opt.equals("--second-pcm")) {
            this.dataModelSecond = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.dataModelFirst = DataModel.PPM;
            this.dataModelSecond = DataModel.PPM;
        } else if (opt.equals("--first-ppm") || opt.equals("--first-pfm")) {
            this.dataModelFirst = DataModel.PPM;
        } else if (opt.equals("--second-ppm") || opt.equals("--second-pfm")) {
            this.dataModelSecond = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            Double effectiveCount;
            this.effectiveCountFirst = effectiveCount = Double.valueOf(argv.remove(0));
            this.effectiveCountSecond = effectiveCount;
        } else if (opt.equals("--first-effective-count")) {
            this.effectiveCountFirst = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--second-effective-count")) {
            this.effectiveCountSecond = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pseudocount")) {
            PseudocountCalculator pseudocount;
            this.pseudocountFirst = pseudocount = PseudocountCalculator.fromString(argv.remove(0));
            this.pseudocountSecond = pseudocount;
        } else if (opt.equals("--first-pseudocount")) {
            this.pseudocountFirst = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--second-pseudocount")) {
            this.pseudocountSecond = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--first-threshold")) {
            this.predefinedFirstThreshold = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--second-threshold")) {
            this.predefinedSecondThreshold = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--position")) {
            String pos_string = argv.remove(0);
            String[] pos_tokens = pos_string.split(",");
            if (pos_tokens[0].equals("all") || pos_tokens[0].equals("any")) {
                this.fixedStrand = Orientation.valueOf(pos_tokens[1]);
            } else {
                Integer shift = Integer.valueOf(pos_tokens[0]);
                String orientation = pos_tokens[1];
                this.relativePosition = new Position((int)shift, orientation);
            }
        } else if (opt.equals("--transpose")) {
            this.transposeFirst = true;
            this.transposeSecond = true;
        } else if (opt.equals("--first-transpose")) {
            this.transposeFirst = true;
        } else if (opt.equals("--second-transpose")) {
            this.transposeSecond = true;
        } else if (this.failed_to_recognize_additional_options(opt, argv)) {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    public ReportLayout<ComparisonSimilarityInfo> report_table_layout() {
        ReportLayout<ComparisonSimilarityInfo> layout = new ReportLayout<ComparisonSimilarityInfo>();
        layout.add_parameter("V", "discretization", this.discretizer);
        if (this.predefinedFirstThreshold == null || this.predefinedSecondThreshold == null) {
            layout.add_parameter("P", "requested P-value", this.pvalue);
        }
        if (this.predefinedFirstThreshold != null) {
            layout.add_parameter("T1", "threshold for the 1st matrix", this.predefinedFirstThreshold);
        }
        if (this.predefinedSecondThreshold != null) {
            layout.add_parameter("T2", "threshold for the 2nd matrix", this.predefinedSecondThreshold);
        }
        layout.add_parameter("PB", "P-value boundary", (Object)this.pvalueBoundary);
        layout.background_parameter("B", "background", (GeneralizedBackgroundModel)this.background);
        layout.add_resulting_value("S", "similarity", ComparisonSimilarityInfo::similarity);
        layout.add_resulting_value("D", "distance (1-similarity)", ComparisonSimilarityInfo::distance);
        layout.add_resulting_value("L", "length of the alignment", ComparisonSimilarityInfo::length);
        layout.add_resulting_value("SH", "shift of the 2nd PWM relative to the 1st", ComparisonSimilarityInfo::shift);
        layout.add_resulting_value("OR", "orientation of the 2nd PWM relative to the 1st", ComparisonSimilarityInfo::orientation);
        layout.add_resulting_value("A1", "aligned 1st matrix", ComparisonSimilarityInfo::first_model_alignment);
        layout.add_resulting_value("A2", "aligned 2nd matrix", ComparisonSimilarityInfo::second_model_alignment);
        layout.add_resulting_value("W", "number of words recognized by both models (model = PWM + threshold)", ComparisonSimilarityInfo::getRecognizedByBoth);
        layout.add_resulting_value("W1", "number of words and recognized by the first model", ComparisonSimilarityInfo::getRecognizedByFirst);
        layout.add_resulting_value("P1", "P-value for the 1st matrix", info -> info.realPvalueFirst(this.background.volume()));
        if (this.predefinedFirstThreshold == null) {
            layout.add_resulting_value("T1", "threshold for the 1st matrix", info -> this.thresholdFirst());
        }
        layout.add_resulting_value("W2", "number of words recognized by the 2nd model", ComparisonSimilarityInfo::getRecognizedBySecond);
        layout.add_resulting_value("P2", "P-value for the 2nd matrix", info -> info.realPvalueSecond(this.background.volume()));
        if (this.predefinedSecondThreshold == null) {
            layout.add_resulting_value("T2", "threshold for the 2nd matrix", info -> this.thresholdSecond());
        }
        return layout;
    }

    protected ComparisonSimilarityInfo results() {
        CompareModels<Alignable> calc = new CompareModels<Alignable>((Alignable)this.firstPWM, (Alignable)this.secondPWM, this.background.volume(), this.discretizer, this.calc_alignment());
        double thresholdFirst = this.thresholdFirst();
        double thresholdSecond = this.thresholdSecond();
        FoundedPvalueInfo countByThresholdFirst = new FindPvalueAPE<ModelType, BackgroundType>(this.firstPWM, this.background, this.discretizer).pvalueByThreshold(thresholdFirst);
        FoundedPvalueInfo countByThresholdSecond = new FindPvalueAPE<ModelType, BackgroundType>(this.secondPWM, this.background, this.discretizer).pvalueByThreshold(thresholdSecond);
        if (this.relativePosition != null) {
            return calc.jaccardAtPosition(countByThresholdFirst, countByThresholdSecond, this.relativePosition);
        }
        if (this.fixedStrand != null) {
            return calc.jaccardFixedStrand(countByThresholdFirst, countByThresholdSecond, this.fixedStrand);
        }
        return calc.jaccard(countByThresholdFirst, countByThresholdSecond);
    }

    protected double thresholdFirst() {
        if (this.cacheFirstThreshold == null) {
            if (this.predefinedFirstThreshold != null) {
                this.cacheFirstThreshold = this.predefinedFirstThreshold;
            } else {
                FindThresholdAPE<ModelType, BackgroundType> pvalue_calculator = new FindThresholdAPE<ModelType, BackgroundType>(this.firstPWM, this.background, this.discretizer);
                this.cacheFirstThreshold = pvalue_calculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundary).threshold;
            }
        }
        return this.cacheFirstThreshold;
    }

    protected double thresholdSecond() {
        if (this.cacheSecondThreshold == null) {
            if (this.predefinedSecondThreshold != null) {
                this.cacheSecondThreshold = this.predefinedSecondThreshold;
            } else {
                FindThresholdAPE<ModelType, BackgroundType> pvalue_calculator = new FindThresholdAPE<ModelType, BackgroundType>(this.secondPWM, this.background, this.discretizer);
                this.cacheSecondThreshold = pvalue_calculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundary).threshold;
            }
        }
        return this.cacheSecondThreshold;
    }
}

