/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.cli.generalized;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.calculation.findThreshold.FindThresholdBsearch;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.Helper;
import ru.autosome.commons.cli.ReportListLayout;
import ru.autosome.commons.cli.TextListReporter;
import ru.autosome.commons.importer.InputExtensions;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreDistribution;
import ru.autosome.commons.motifModel.types.DataModel;
import ru.autosome.macroape.calculation.generalized.AlignedModelIntersection;
import ru.autosome.macroape.calculation.generalized.ScanningCollection;
import ru.autosome.macroape.model.ComparisonSimilarityInfo;
import ru.autosome.macroape.model.PairAligned;
import ru.autosome.macroape.model.ScanningSimilarityInfo;
import ru.autosome.macroape.model.ThresholdEvaluator;

public abstract class ScanCollection<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected DataModel collectionDataModel;
    protected Double collectionEffectiveCount;
    protected PseudocountCalculator collectionPseudocount;
    protected DataModel queryDataModel;
    protected Double queryEffectiveCount;
    protected PseudocountCalculator queryPseudocount;
    protected BackgroundType background;
    protected Discretizer roughDiscretizer;
    protected Discretizer preciseDiscretizer;
    protected double pvalue;
    protected Double queryPredefinedThreshold;
    protected Double similarityCutoff;
    protected Double preciseRecalculationCutoff;
    protected BoundaryType pvalueBoundaryType;
    protected String queryPMFilename;
    protected File pathToCollectionOfPWMs;
    protected File thresholds_folder;
    protected ModelType queryPWM;
    protected List<ThresholdEvaluator<ModelType>> pwmCollection;
    protected boolean queryTranspose;
    protected boolean collectionTranspose;

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <query PWM file> <folder with PWMs> [options]\n\nOptions:\n  [--pvalue <P-value>] or [-p]\n  [--similarity-cutoff <similarity cutoff>] or [-c] minimal similarity to be included in output, '--similarity-cutoff 0.05' by default, [--all] to print all results\n  [--precise [<level>]] minimal similarity to check on the second pass in precise mode, off by default, '--precise 0.01' if level is not set\n  [--rough-discretization <discretization level>] or [-d]\n  [--precise-discretization <discretization level>]\n  [--[query-|collection-]pcm] - treat the query input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--[query-|collection-]ppm] or [--pfm] - treat the query input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--[query-|collection-]effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n  [--background <background probabilities>] or [-b] " + this.DOC_background_option() + "\n  [--precalc <folder>] - specify folder with thresholds for PWM collection (for fast-and-rough calculation).\n                         Attention! Don't use threshold lists calculated for a different discretization (or background)!\n  [--[query-|collection-]transpose] - load motif from transposed matrix (nucleotides in lines).\n" + this.DOC_additional_options() + "\nOutput format:\n           <name> <jaccard index> <shift> <overlap> <orientation> ['*' in case that result was calculated on the second pass (in precise mode), '.' otherwise]\n              Attention! Name can contain whitespace characters.\n              Attention! The shift and orientation are reported for the collection matrix relative to the query matrix.\n\nExamples:\n  " + this.DOC_run_string() + " ./query_motif.pwm ./hocomoco/ --precalc ./hocomoco_thresholds\n  " + this.DOC_run_string() + " ./query_motif.pcm ./hocomoco/ --pcm -p 0.0005 --precise 0.03\n";
    }

    protected String DOC_additional_options() {
        return "";
    }

    protected ScanCollection() {
        this.initialize_defaults();
    }

    protected void extract_query_pm_filename(List<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.queryPMFilename = argv.remove(0);
    }

    protected void extract_path_to_collection_of_pwms(List<String> argv) {
        try {
            this.pathToCollectionOfPWMs = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify PWM-collection folder", e);
        }
    }

    protected abstract BackgroundType extractBackground(String var1);

    protected abstract void initialize_default_background();

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.roughDiscretizer = new Discretizer(1.0);
        this.preciseDiscretizer = new Discretizer(10.0);
        this.queryDataModel = DataModel.PWM;
        this.collectionDataModel = DataModel.PWM;
        this.queryEffectiveCount = 100.0;
        this.queryPseudocount = PseudocountCalculator.logPseudocount;
        this.collectionEffectiveCount = 100.0;
        this.collectionPseudocount = PseudocountCalculator.logPseudocount;
        this.thresholds_folder = null;
        this.pvalueBoundaryType = BoundaryType.WEAK;
        this.pvalue = 5.0E-4;
        this.similarityCutoff = 0.05;
        this.preciseRecalculationCutoff = null;
        this.queryTranspose = false;
        this.collectionTranspose = false;
    }

    protected void extract_option(List<String> argv) throws FileNotFoundException {
        String opt = argv.remove(0);
        if (opt.equals("-b") || opt.equals("--background")) {
            this.background = this.extractBackground(argv.remove(0));
        } else if (opt.equals("--rough-discretization") || opt.equals("-d") || opt.equals("--discretization")) {
            this.roughDiscretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--precise-discretization")) {
            this.preciseDiscretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalueBoundaryType = BoundaryType.fromString(argv.remove(0));
        } else if (opt.equals("--pcm")) {
            this.queryDataModel = DataModel.PCM;
            this.collectionDataModel = DataModel.PCM;
        } else if (opt.equals("--query-pcm")) {
            this.queryDataModel = DataModel.PCM;
        } else if (opt.equals("--collection-pcm")) {
            this.collectionDataModel = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.queryDataModel = DataModel.PPM;
            this.collectionDataModel = DataModel.PPM;
        } else if (opt.equals("--query-ppm") || opt.equals("--query-pfm")) {
            this.queryDataModel = DataModel.PPM;
        } else if (opt.equals("--collection-ppm") || opt.equals("--collection-pfm")) {
            this.collectionDataModel = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            Double effectiveCount;
            this.queryEffectiveCount = effectiveCount = Double.valueOf(argv.remove(0));
            this.collectionEffectiveCount = effectiveCount;
        } else if (opt.equals("--query-effective-count")) {
            this.queryEffectiveCount = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--collection-effective-count")) {
            this.collectionEffectiveCount = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pseudocount")) {
            PseudocountCalculator pseudocount;
            this.queryPseudocount = pseudocount = PseudocountCalculator.fromString(argv.remove(0));
            this.collectionPseudocount = pseudocount;
        } else if (opt.equals("--query-pseudocount")) {
            this.queryPseudocount = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--collection-pseudocount")) {
            this.collectionPseudocount = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--precalc")) {
            this.thresholds_folder = new File(argv.remove(0));
            if (!this.thresholds_folder.exists()) {
                throw new FileNotFoundException("Specified folder with thresholds `" + this.thresholds_folder + "` not exists");
            }
            if (!this.thresholds_folder.isDirectory()) {
                throw new FileNotFoundException("`" + this.thresholds_folder + "` is not a directory");
            }
        } else if (opt.equals("-p") || opt.equals("--pvalue")) {
            this.pvalue = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--predefined-threshold")) {
            this.queryPredefinedThreshold = Double.valueOf(argv.remove(0));
        } else if (opt.equals("-c") || opt.equals("--similarity-cutoff")) {
            this.similarityCutoff = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--all")) {
            this.similarityCutoff = 0.0;
        } else if (opt.equals("--precise")) {
            this.preciseRecalculationCutoff = !argv.isEmpty() && InputExtensions.isDouble(argv.get(0)) ? Double.valueOf(argv.remove(0)) : Double.valueOf(0.01);
        } else if (opt.equals("--transpose")) {
            this.queryTranspose = true;
            this.collectionTranspose = true;
        } else if (opt.equals("--query-transpose")) {
            this.queryTranspose = true;
        } else if (opt.equals("--collection-transpose")) {
            this.collectionTranspose = true;
        } else if (this.failed_to_recognize_additional_options(opt, argv)) {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        return true;
    }

    public ReportListLayout<ScanningSimilarityInfo> report_table_layout() {
        ReportListLayout<ScanningSimilarityInfo> infos = new ReportListLayout<ScanningSimilarityInfo>();
        infos.add_parameter("MS", "minimal similarity to output", this.similarityCutoff);
        infos.add_parameter("P", "P-value", this.pvalue);
        infos.add_parameter("PB", "P-value boundary", (Object)this.pvalueBoundaryType);
        if (this.preciseRecalculationCutoff != null) {
            infos.add_parameter("VR", "discretization value, rough", this.roughDiscretizer);
            infos.add_parameter("VP", "discretization value, precise", this.preciseDiscretizer);
            infos.add_parameter("MP", "minimal similarity for the 2nd pass in 'precise' mode", this.preciseRecalculationCutoff);
        } else {
            infos.add_parameter("V", "discretization value", this.roughDiscretizer);
        }
        infos.background_parameter("B", "background", (GeneralizedBackgroundModel)this.background);
        infos.add_table_parameter("motif", cell -> cell.name);
        infos.add_table_parameter("similarity", ComparisonSimilarityInfo::similarity);
        infos.add_table_parameter("shift", ComparisonSimilarityInfo::shift);
        infos.add_table_parameter("overlap", ComparisonSimilarityInfo::overlap);
        infos.add_table_parameter("orientation", ComparisonSimilarityInfo::orientation);
        if (this.preciseRecalculationCutoff != null) {
            infos.add_table_parameter("precise mode", cell -> cell.precise ? "*" : ".");
        }
        return infos;
    }

    protected String report(List<ScanningSimilarityInfo> data) {
        data.sort(Comparator.comparing(ComparisonSimilarityInfo::similarity));
        ReportListLayout<ScanningSimilarityInfo> layout = this.report_table_layout();
        TextListReporter<ScanningSimilarityInfo> reporter = new TextListReporter<ScanningSimilarityInfo>();
        return reporter.report(data, layout);
    }

    protected List<ScanningSimilarityInfo> process() {
        return this.calculator().similarityInfos().collect(Collectors.toList());
    }

    protected List<ThresholdEvaluator<ModelType>> load_collection_of_pwms() throws FileNotFoundException {
        List<Named<ModelType>> pwmList = this.loadMotifCollection();
        ArrayList<ThresholdEvaluator<ModelType>> result = new ArrayList<ThresholdEvaluator<ModelType>>();
        for (Named<ModelType> namedModel : pwmList) {
            Discretable pwm = (Discretable)namedModel.getObject();
            if (this.thresholds_folder == null) {
                FindThresholdAPE<Discretable, BackgroundType> roughEvaluator = new FindThresholdAPE<Discretable, BackgroundType>(pwm, this.background, this.roughDiscretizer);
                FindThresholdAPE<Discretable, BackgroundType> preciseEvaluator = new FindThresholdAPE<Discretable, BackgroundType>(pwm, this.background, this.preciseDiscretizer);
                result.add(new ThresholdEvaluator<Discretable>(namedModel.getName(), pwm, roughEvaluator, preciseEvaluator));
                continue;
            }
            File thresholds_file = new File(this.thresholds_folder, namedModel.getName() + ".thr");
            result.add(new ThresholdEvaluator<Discretable>(namedModel.getName(), pwm, new FindThresholdBsearch(thresholds_file), null));
        }
        return result;
    }

    protected void setup_from_arglist(String[] args) throws FileNotFoundException {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        this.setup_from_arglist(argv);
    }

    protected void setup_from_arglist(List<String> argv) throws FileNotFoundException {
        Helper.print_help_if_requested(argv, this.documentString());
        this.extract_query_pm_filename(argv);
        this.extract_path_to_collection_of_pwms(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.queryPWM = this.loadQueryMotif();
        this.pwmCollection = this.load_collection_of_pwms();
    }

    protected ScanningCollection<ModelType, BackgroundType> calculator() {
        ScanningCollection calculator = new ScanningCollection(this.pwmCollection, (Alignable)this.queryPWM, this.calc_alignment());
        calculator.pvalue = this.pvalue;
        calculator.queryPredefinedThreshold = this.queryPredefinedThreshold;
        calculator.roughDiscretizer = this.roughDiscretizer;
        calculator.preciseDiscretizer = this.preciseDiscretizer;
        calculator.background = this.background;
        calculator.pvalueBoundaryType = this.pvalueBoundaryType;
        calculator.similarityCutoff = this.similarityCutoff;
        calculator.preciseRecalculationCutoff = this.preciseRecalculationCutoff;
        return calculator;
    }

    protected abstract Function<PairAligned<ModelType>, ? extends AlignedModelIntersection> calc_alignment();

    protected abstract List<Named<ModelType>> loadMotifCollection();

    protected abstract ModelType loadQueryMotif();
}

