/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.di;

import java.util.List;
import java.util.function.Function;
import ru.autosome.commons.backgroundModel.di.DiBackground;
import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.backgroundModel.di.DiWordwiseBackground;
import ru.autosome.commons.cli.ReportLayout;
import ru.autosome.commons.cli.TextReporter;
import ru.autosome.commons.importer.DiPWMFromMonoImporter;
import ru.autosome.commons.importer.DiPWMImporter;
import ru.autosome.commons.importer.MotifImporter;
import ru.autosome.commons.motifModel.di.DiPWM;
import ru.autosome.macroape.calculation.di.AlignedModelIntersection;
import ru.autosome.macroape.model.ComparisonSimilarityInfo;
import ru.autosome.macroape.model.PairAligned;

public class EvalSimilarity
extends ru.autosome.macroape.cli.generalized.EvalSimilarity<DiPWM, DiBackgroundModel> {
    boolean firstPWMFromMononucleotide;
    boolean secondPWMFromMononucleotide;

    @Override
    protected String DOC_background_option() {
        return "ACGT - 16 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.02,0.03,0.03,0.02,0.08,0.12,0.12,0.08,0.08,0.12,0.12,0.08,0.02,0.03,0.03,0.02";
    }

    @Override
    protected String DOC_run_string() {
        return "java ru.autosome.macroape.di.EvalSimilarity";
    }

    @Override
    protected String DOC_additional_options() {
        return "  [--first-from-mono]  - obtain first DiPWM from mono PWM/PCM/PPM.\n  [--second-from-mono] - obtain second DiPWM from mono PWM/PCM/PPM.\n";
    }

    @Override
    protected void initialize_defaults() {
        super.initialize_defaults();
        this.firstPWMFromMononucleotide = false;
        this.secondPWMFromMononucleotide = false;
    }

    @Override
    protected void initialize_default_background() {
        this.background = new DiWordwiseBackground();
    }

    @Override
    protected DiBackgroundModel extract_background(String str) {
        return DiBackground.fromString(str);
    }

    @Override
    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        if (opt.equals("--first-from-mono")) {
            this.firstPWMFromMononucleotide = true;
            return false;
        }
        if (opt.equals("--second-from-mono")) {
            this.secondPWMFromMononucleotide = true;
            return false;
        }
        return true;
    }

    @Override
    protected DiPWM loadFirstPWM(String filename) {
        MotifImporter importer = this.firstPWMFromMononucleotide ? new DiPWMFromMonoImporter((DiBackgroundModel)this.background, this.dataModelFirst, this.effectiveCountFirst, this.transposeFirst, this.pseudocountFirst) : new DiPWMImporter((DiBackgroundModel)this.background, this.dataModelFirst, this.effectiveCountFirst, this.transposeFirst, this.pseudocountFirst);
        return (DiPWM)importer.loadMotif(filename);
    }

    @Override
    protected DiPWM loadSecondPWM(String filename) {
        MotifImporter importer = this.secondPWMFromMononucleotide ? new DiPWMFromMonoImporter((DiBackgroundModel)this.background, this.dataModelSecond, this.effectiveCountSecond, this.transposeSecond, this.pseudocountSecond) : new DiPWMImporter((DiBackgroundModel)this.background, this.dataModelSecond, this.effectiveCountSecond, this.transposeSecond, this.pseudocountSecond);
        return (DiPWM)importer.loadMotif(filename);
    }

    private static EvalSimilarity from_arglist(String[] args) {
        EvalSimilarity result = new EvalSimilarity();
        result.setup_from_arglist(args);
        return result;
    }

    @Override
    protected Function<PairAligned<DiPWM>, AlignedModelIntersection> calc_alignment() {
        return alignment -> new AlignedModelIntersection((PairAligned<DiPWM>)alignment, (DiBackgroundModel)this.background);
    }

    public static void main(String[] args) {
        try {
            EvalSimilarity cli = EvalSimilarity.from_arglist(args);
            ComparisonSimilarityInfo result = cli.results();
            ReportLayout<ComparisonSimilarityInfo> layout = cli.report_table_layout();
            TextReporter<ComparisonSimilarityInfo> reporter = new TextReporter<ComparisonSimilarityInfo>();
            System.out.println(reporter.report(result, layout));
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\n" + new EvalSimilarity().documentString());
            System.exit(1);
        }
    }
}

