package ru.autosome.ape.calculation.findThreshold;

import ru.autosome.ape.model.PvalueBsearchList;

import java.io.File;
import java.io.FileNotFoundException;

public class FindThresholdBsearchBuilder {
  final File pathToThresholds;

  public FindThresholdBsearchBuilder(File pathToThresholds) {
    this.pathToThresholds = pathToThresholds;
  }

  public CanFindThreshold thresholdCalculator(String motifName) {
    try {
      File thresholds_file = new File(pathToThresholds, motifName + ".thr");
      PvalueBsearchList pvalueBsearchList = PvalueBsearchList.load_from_file(thresholds_file);
      return new FindThresholdBsearch(pvalueBsearchList);
    } catch (FileNotFoundException e) {
      return null;
    }
  }
}
